/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.FrequencyEditor;
import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceUnavailableAlert;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.Category;
import io.github.dsheirer.rrapi.type.Frequency;
import io.github.dsheirer.rrapi.type.Mode;
import io.github.dsheirer.rrapi.type.SubCategory;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.util.ThreadPool;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgencyFrequencyEditor
extends GridPane {
    private static final Logger mLog = LoggerFactory.getLogger(AgencyFrequencyEditor.class);
    private static final Category ALL_CATEGORIES = new AllCategories();
    private static final SubCategory ALL_SUB_CATEGORIES = new AllSubCategories();
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private PlaylistManager mPlaylistManager;
    private Level mLevel;
    private ComboBox<Category> mCategoryComboBox;
    private ComboBox<SubCategory> mSubCategoryComboBox;
    private TableView<Frequency> mFrequencyTableView;
    private Label mPlaceholderLabel;
    private ProgressIndicator mProgressIndicator;
    private FrequencyEditor mFrequencyEditor;

    public AgencyFrequencyEditor(UserPreferences userPreferences, RadioReference radioReference, PlaylistManager playlistManager, Level level) {
        this.mUserPreferences = userPreferences;
        this.mRadioReference = radioReference;
        this.mPlaylistManager = playlistManager;
        this.mLevel = level;
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.setVgap(10.0);
        this.setHgap(10.0);
        this.setMaxHeight(Double.MAX_VALUE);
        int row = 0;
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints();
        ColumnConstraints column3 = new ColumnConstraints();
        column3.setPercentWidth(40.0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        Label categoryLabel = new Label("Category");
        GridPane.setConstraints((Node)categoryLabel, (int)0, (int)row);
        GridPane.setHalignment((Node)categoryLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)categoryLabel);
        GridPane.setConstraints(this.getCategoryComboBox(), (int)1, (int)row);
        GridPane.setHgrow(this.getCategoryComboBox(), (Priority)Priority.ALWAYS);
        this.getChildren().add(this.getCategoryComboBox());
        Label subCategoryLabel = new Label("Sub-Category");
        GridPane.setConstraints((Node)subCategoryLabel, (int)0, (int)(++row));
        GridPane.setHalignment((Node)subCategoryLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)subCategoryLabel);
        GridPane.setConstraints(this.getSubCategoryComboBox(), (int)1, (int)row);
        GridPane.setHgrow(this.getSubCategoryComboBox(), (Priority)Priority.ALWAYS);
        this.getChildren().add(this.getSubCategoryComboBox());
        GridPane.setConstraints(this.getFrequencyTableView(), (int)0, (int)(++row), (int)2, (int)1);
        GridPane.setHgrow(this.getFrequencyTableView(), (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.getFrequencyTableView(), (Priority)Priority.ALWAYS);
        this.getChildren().add(this.getFrequencyTableView());
        GridPane.setConstraints((Node)this.getFrequencyEditor(), (int)2, (int)0, (int)1, (int)3);
        GridPane.setHgrow((Node)this.getFrequencyEditor(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getFrequencyEditor());
    }

    public void setLoading(boolean loading) {
        if (Platform.isFxApplicationThread()) {
            this.getFrequencyTableView().setPlaceholder((Node)(loading ? this.getProgressIndicator() : this.getPlaceholderLabel()));
        } else {
            Platform.runLater(() -> this.getFrequencyTableView().setPlaceholder((Node)(loading ? this.getProgressIndicator() : this.getPlaceholderLabel())));
        }
    }

    public void clear() {
        this.getCategoryComboBox().getItems().clear();
        this.getSubCategoryComboBox().getItems().clear();
        this.getFrequencyTableView().getItems().clear();
    }

    public void clearAndSetLoading() {
        this.clear();
        this.setLoading(true);
    }

    public void setCategories(List<Category> categories) {
        this.clear();
        if (categories != null) {
            Collections.sort(categories, new CategoryComparator(this));
        }
        if (categories != null && !categories.isEmpty()) {
            if (categories.size() < 10) {
                categories.add(0, ALL_CATEGORIES);
            }
            this.getCategoryComboBox().getItems().addAll(categories);
            this.getCategoryComboBox().getSelectionModel().select((Object)categories.get(0));
        } else {
            this.setLoading(false);
        }
    }

    private FrequencyEditor getFrequencyEditor() {
        if (this.mFrequencyEditor == null) {
            this.mFrequencyEditor = new FrequencyEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, this.mLevel);
        }
        return this.mFrequencyEditor;
    }

    private ProgressIndicator getProgressIndicator() {
        if (this.mProgressIndicator == null) {
            this.mProgressIndicator = new ProgressIndicator();
            this.mProgressIndicator.setProgress(-1.0);
        }
        return this.mProgressIndicator;
    }

    private Label getPlaceholderLabel() {
        if (this.mPlaceholderLabel == null) {
            this.mPlaceholderLabel = new Label("Select an Agency to View Frequency Records");
        }
        return this.mPlaceholderLabel;
    }

    private TableView<Frequency> getFrequencyTableView() {
        if (this.mFrequencyTableView == null) {
            this.mFrequencyTableView = new TableView();
            this.mFrequencyTableView.setMaxHeight(Double.MAX_VALUE);
            this.mFrequencyTableView.setPlaceholder((Node)this.getPlaceholderLabel());
            TableColumn descriptionColumn = new TableColumn();
            descriptionColumn.setText("Description");
            descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
            descriptionColumn.setPrefWidth(300.0);
            TableColumn frequencyColumn = new TableColumn();
            frequencyColumn.setText("Frequency");
            frequencyColumn.setCellValueFactory((Callback)new FrequencyCellValueFactory(this));
            frequencyColumn.setPrefWidth(100.0);
            TableColumn modeColumn = new TableColumn();
            modeColumn.setText("Mode");
            modeColumn.setCellValueFactory((Callback)new ModeCellValueFactory());
            modeColumn.setPrefWidth(100.0);
            this.mFrequencyTableView.getColumns().addAll((Object[])new TableColumn[]{descriptionColumn, frequencyColumn, modeColumn});
            this.mFrequencyTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, selected) -> {
                if (selected != null) {
                    SubCategory subCategory = this.getSubCategory(selected.getSubCategoryId());
                    Category category = this.getCategory(subCategory);
                    this.getFrequencyEditor().setItem((Frequency)selected, category, subCategory);
                } else {
                    this.getFrequencyEditor().setItem(null, null, null);
                }
            });
        }
        return this.mFrequencyTableView;
    }

    private Category getCategory(SubCategory subCategory) {
        if (subCategory != null) {
            for (Category category : this.getCategoryComboBox().getItems()) {
                for (SubCategory sub : category.getSubCategories()) {
                    if (sub != subCategory) continue;
                    return category;
                }
            }
        }
        return null;
    }

    private SubCategory getSubCategory(int id) {
        for (SubCategory subCategory : this.getSubCategoryComboBox().getItems()) {
            if (subCategory.getSubCategoryId() != id) continue;
            return subCategory;
        }
        return null;
    }

    private ComboBox<Category> getCategoryComboBox() {
        if (this.mCategoryComboBox == null) {
            this.mCategoryComboBox = new ComboBox();
            this.mCategoryComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mCategoryComboBox.setOnAction(event -> {
                this.getFrequencyTableView().getItems().clear();
                this.getSubCategoryComboBox().getItems().clear();
                Category selected = (Category)this.mCategoryComboBox.getSelectionModel().getSelectedItem();
                if (selected != null) {
                    ArrayList subCategories = new ArrayList();
                    if (selected.equals(ALL_CATEGORIES)) {
                        for (Category category : this.getCategoryComboBox().getItems()) {
                            if (category.getSubCategories() == null) continue;
                            subCategories.addAll(category.getSubCategories());
                        }
                    } else if (selected.getSubCategories() != null) {
                        subCategories.addAll(selected.getSubCategories());
                    }
                    Collections.sort(subCategories, new SubCategoryComparator(this));
                    this.getSubCategoryComboBox().getItems().add((Object)ALL_SUB_CATEGORIES);
                    this.getSubCategoryComboBox().getItems().addAll(subCategories);
                    this.getSubCategoryComboBox().getSelectionModel().select((Object)ALL_SUB_CATEGORIES);
                }
            });
            this.mCategoryComboBox.setConverter((StringConverter)new StringConverter<Category>(){

                public String toString(Category category) {
                    if (category != null) {
                        return category.getName();
                    }
                    return null;
                }

                public Category fromString(String string) {
                    if (string != null) {
                        for (Category category : AgencyFrequencyEditor.this.mCategoryComboBox.getItems()) {
                            if (!category.getName().contentEquals(string)) continue;
                            return category;
                        }
                    }
                    return null;
                }
            });
        }
        return this.mCategoryComboBox;
    }

    private ComboBox<SubCategory> getSubCategoryComboBox() {
        if (this.mSubCategoryComboBox == null) {
            this.mSubCategoryComboBox = new ComboBox();
            this.mSubCategoryComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mSubCategoryComboBox.setConverter((StringConverter)new StringConverter<SubCategory>(){

                public String toString(SubCategory subCategory) {
                    if (subCategory != null) {
                        return subCategory.getName();
                    }
                    return null;
                }

                public SubCategory fromString(String string) {
                    if (string != null) {
                        for (SubCategory subCategory : AgencyFrequencyEditor.this.mSubCategoryComboBox.getItems()) {
                            if (!subCategory.getName().contentEquals(string)) continue;
                            return subCategory;
                        }
                    }
                    return null;
                }
            });
            this.mSubCategoryComboBox.setOnAction(event -> {
                this.setLoading(true);
                this.getFrequencyTableView().getItems().clear();
                SubCategory subCategory = (SubCategory)this.mSubCategoryComboBox.getValue();
                if (subCategory != null) {
                    ThreadPool.CACHED.submit(() -> {
                        try {
                            ArrayList frequencies = new ArrayList();
                            if (subCategory.equals(ALL_SUB_CATEGORIES)) {
                                for (SubCategory subCategory1 : this.getSubCategoryComboBox().getItems()) {
                                    List subCatFrequencies;
                                    if (subCategory1.equals(ALL_SUB_CATEGORIES) || (subCatFrequencies = this.mRadioReference.getService().getSubCategoryFrequencies(subCategory1.getSubCategoryId())) == null) continue;
                                    frequencies.addAll(subCatFrequencies);
                                }
                            } else {
                                List subCatFrequencies = this.mRadioReference.getService().getSubCategoryFrequencies(subCategory.getSubCategoryId());
                                if (subCatFrequencies != null) {
                                    frequencies.addAll(subCatFrequencies);
                                }
                            }
                            Collections.sort(frequencies, new FrequencyComparator(this));
                            Platform.runLater(() -> {
                                this.getFrequencyTableView().getItems().addAll((Collection)frequencies);
                                this.setLoading(false);
                            });
                        }
                        catch (Throwable t) {
                            mLog.error("Error retrieving frequencies for subcategory [" + subCategory.getName() + "]", t);
                            Platform.runLater(() -> new RadioReferenceUnavailableAlert((Node)this.getSubCategoryComboBox()).showAndWait());
                        }
                    });
                }
            });
        }
        return this.mSubCategoryComboBox;
    }

    public class CategoryComparator
    implements Comparator<Category> {
        public CategoryComparator(AgencyFrequencyEditor this$0) {
        }

        @Override
        public int compare(Category o1, Category o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return 1;
            }
            if (o2.getName() == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public class FrequencyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Frequency, String>, ObservableValue<String>> {
        private final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("0.00000");
        private SimpleStringProperty mFrequencyFormatted = new SimpleStringProperty();

        public FrequencyCellValueFactory(AgencyFrequencyEditor this$0) {
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<Frequency, String> param) {
            this.mFrequencyFormatted.set(this.FREQUENCY_FORMATTER.format(((Frequency)param.getValue()).getDownlink()));
            return this.mFrequencyFormatted;
        }
    }

    public class ModeCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Frequency, String>, ObservableValue<String>> {
        private SimpleStringProperty mMode = new SimpleStringProperty();

        public ObservableValue<String> call(TableColumn.CellDataFeatures<Frequency, String> param) {
            String mode = ((Frequency)param.getValue()).getMode();
            try {
                Integer modeInt = Integer.valueOf(mode);
                Mode modeObj = (Mode)AgencyFrequencyEditor.this.mRadioReference.getService().getModesMap().get(modeInt);
                if (modeObj != null) {
                    this.mMode.set(modeObj != null ? modeObj.getName() : null);
                }
            }
            catch (Exception pe) {
                this.mMode.set("Error");
            }
            return this.mMode;
        }
    }

    public class FrequencyComparator
    implements Comparator<Frequency> {
        public FrequencyComparator(AgencyFrequencyEditor this$0) {
        }

        @Override
        public int compare(Frequency o1, Frequency o2) {
            if (o1.getAlphaTag() == null && o2.getAlphaTag() == null) {
                return 0;
            }
            if (o1.getAlphaTag() == null) {
                return 1;
            }
            if (o2.getAlphaTag() == null) {
                return -1;
            }
            return o1.getAlphaTag().compareTo(o2.getAlphaTag());
        }
    }

    public class SubCategoryComparator
    implements Comparator<SubCategory> {
        public SubCategoryComparator(AgencyFrequencyEditor this$0) {
        }

        @Override
        public int compare(SubCategory o1, SubCategory o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return 1;
            }
            if (o2.getName() == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AllCategories
    extends Category {
        public AllCategories() {
            this.setCategoryId(-1);
            this.setName("(All)");
        }
    }

    public static class AllSubCategories
    extends SubCategory {
        public AllSubCategories() {
            this.setSubCategoryId(-1);
            this.setName("(All)");
        }
    }
}

