/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.decoder.AuxDecoderConfigurationEditor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.passport.DecodeConfigPassport;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassportConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(PassportConfigurationEditor.class);
    private TitledPane mAuxDecoderPane;
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private AuxDecoderConfigurationEditor mAuxDecoderConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;

    public PassportConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getAuxDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.PASSPORT;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: Passport");
            this.mDecoderPane.setExpanded(false);
            this.mDecoderPane.setDisable(true);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getAuxDecoderPane() {
        if (this.mAuxDecoderPane == null) {
            this.mAuxDecoderPane = new TitledPane("Additional Decoders", (Node)this.getAuxDecoderConfigurationEditor());
            this.mAuxDecoderPane.setExpanded(false);
        }
        return this.mAuxDecoderPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private AuxDecoderConfigurationEditor getAuxDecoderConfigurationEditor() {
        if (this.mAuxDecoderConfigurationEditor == null) {
            ArrayList<DecoderType> types = new ArrayList<DecoderType>();
            types.add(DecoderType.FLEETSYNC2);
            types.add(DecoderType.MDC1200);
            this.mAuxDecoderConfigurationEditor = new AuxDecoderConfigurationEditor(types);
            this.mAuxDecoderConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mAuxDecoderConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAuxDecoderConfigurationEditor;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
    }

    @Override
    protected void saveDecoderConfiguration() {
        if (!(((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigPassport)) {
            ((Channel)this.getItem()).setDecodeConfiguration(new DecodeConfigPassport());
        }
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
        this.getAuxDecoderConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
        this.getAuxDecoderConfigurationEditor().save();
        if (((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem()).getAuxDecoders().isEmpty()) {
            ((Channel)this.getItem()).setAuxDecodeConfiguration(null);
        } else {
            ((Channel)this.getItem()).setAuxDecodeConfiguration((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }
}

