/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.decoder.AuxDecoderConfigurationEditor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.analog.DecodeConfigAnalog;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.nbfm.DecodeConfigNBFM;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.ToggleSwitch;

public class NBFMConfigurationEditor
extends ChannelConfigurationEditor {
    private TitledPane mAuxDecoderPane;
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private TextField mTalkgroupField;
    private TextField mSquelchThresholdField;
    private ToggleSwitch mSquelchAutoTrackSwitch;
    private ToggleSwitch mAudioFilterEnable;
    private TextFormatter<Integer> mTalkgroupTextFormatter;
    private final IntegerFormatter mSquelchTextFormatter = new IntegerFormatter(-110, 0);
    private ToggleSwitch mBasebandRecordSwitch;
    private SegmentedButton mBandwidthButton;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private AuxDecoderConfigurationEditor mAuxDecoderConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private final TalkgroupValueChangeListener mTalkgroupValueChangeListener = new TalkgroupValueChangeListener();
    private final IntegerFormatter mDecimalFormatter = new IntegerFormatter(1, 65535);
    private final HexFormatter mHexFormatter = new HexFormatter(1, 65535);

    public NBFMConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getAuxDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.NBFM;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: NBFM");
            this.mDecoderPane.setExpanded(true);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            Label bandwidthLabel = new Label("Channel Bandwidth");
            GridPane.setHalignment((Node)bandwidthLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)bandwidthLabel, (int)0, (int)0);
            gridPane.getChildren().add((Object)bandwidthLabel);
            GridPane.setConstraints((Node)this.getBandwidthButton(), (int)1, (int)0);
            gridPane.getChildren().add((Object)this.getBandwidthButton());
            Label squelchLabel = new Label("Squelch Threshold");
            GridPane.setHalignment((Node)squelchLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)squelchLabel, (int)2, (int)0);
            gridPane.getChildren().add((Object)squelchLabel);
            GridPane.setConstraints((Node)this.getSquelchThresholdField(), (int)3, (int)0);
            gridPane.getChildren().add((Object)this.getSquelchThresholdField());
            Label autoTrackLabel = new Label("Squelch Auto-Track");
            GridPane.setHalignment((Node)autoTrackLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)autoTrackLabel, (int)4, (int)0);
            gridPane.getChildren().add((Object)autoTrackLabel);
            GridPane.setConstraints((Node)this.getSquelchAutoTrackSwitch(), (int)5, (int)0);
            GridPane.setHalignment((Node)this.getSquelchAutoTrackSwitch(), (HPos)HPos.LEFT);
            gridPane.getChildren().add((Object)this.getSquelchAutoTrackSwitch());
            Label talkgroupLabel = new Label("Talkgroup To Assign");
            GridPane.setHalignment((Node)talkgroupLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)talkgroupLabel, (int)0, (int)1);
            gridPane.getChildren().add((Object)talkgroupLabel);
            GridPane.setConstraints((Node)this.getTalkgroupField(), (int)1, (int)1);
            gridPane.getChildren().add((Object)this.getTalkgroupField());
            GridPane.setConstraints((Node)this.getAudioFilterEnable(), (int)2, (int)1);
            gridPane.getChildren().add((Object)this.getAudioFilterEnable());
            this.mDecoderPane.setContent((Node)gridPane);
            this.mDecoderPane.expandedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.setDecoderConfiguration(((Channel)this.getItem()).getDecodeConfiguration());
                }
            });
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getAuxDecoderPane() {
        if (this.mAuxDecoderPane == null) {
            this.mAuxDecoderPane = new TitledPane("Additional Decoders", (Node)this.getAuxDecoderConfigurationEditor());
            this.mAuxDecoderPane.setExpanded(false);
        }
        return this.mAuxDecoderPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            GridPane.setConstraints((Node)this.getBasebandRecordSwitch(), (int)0, (int)0);
            gridPane.getChildren().add((Object)this.getBasebandRecordSwitch());
            Label recordBasebandLabel = new Label("Channel (Baseband I&Q)");
            GridPane.setHalignment((Node)recordBasebandLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)recordBasebandLabel, (int)1, (int)0);
            gridPane.getChildren().add((Object)recordBasebandLabel);
            this.mRecordPane.setContent((Node)gridPane);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private AuxDecoderConfigurationEditor getAuxDecoderConfigurationEditor() {
        if (this.mAuxDecoderConfigurationEditor == null) {
            this.mAuxDecoderConfigurationEditor = new AuxDecoderConfigurationEditor(DecoderType.AUX_DECODERS);
            this.mAuxDecoderConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mAuxDecoderConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAuxDecoderConfigurationEditor;
    }

    private ToggleSwitch getAudioFilterEnable() {
        if (this.mAudioFilterEnable == null) {
            this.mAudioFilterEnable = new ToggleSwitch("High-Pass Audio Filter");
            this.mAudioFilterEnable.setTooltip(new Tooltip("High-pass filter to remove DC offset and sub-audible signalling"));
            this.mAudioFilterEnable.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAudioFilterEnable;
    }

    private SegmentedButton getBandwidthButton() {
        if (this.mBandwidthButton == null) {
            this.mBandwidthButton = new SegmentedButton();
            this.mBandwidthButton.getStyleClass().add((Object)"dark");
            this.mBandwidthButton.setDisable(true);
            for (DecodeConfigAnalog.Bandwidth bandwidth : DecodeConfigAnalog.Bandwidth.FM_BANDWIDTHS) {
                ToggleButton toggleButton = new ToggleButton(bandwidth.toString());
                toggleButton.setUserData((Object)bandwidth);
                this.mBandwidthButton.getButtons().add((Object)toggleButton);
            }
            this.mBandwidthButton.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
            this.mBandwidthButton.getToggleGroup().getToggles().addListener(c -> {
                if (this.getItem() != null && ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigNBFM) {
                    boolean modified = this.modifiedProperty().get();
                    DecodeConfigNBFM config = (DecodeConfigNBFM)((Channel)this.getItem()).getDecodeConfiguration();
                    DecodeConfigAnalog.Bandwidth bandwidth = config.getBandwidth();
                    if (bandwidth == null) {
                        bandwidth = DecodeConfigAnalog.Bandwidth.BW_12_5;
                    }
                    Iterator iterator = this.getBandwidthButton().getToggleGroup().getToggles().iterator();
                    while (iterator.hasNext()) {
                        Toggle toggle;
                        toggle.setSelected((toggle = (Toggle)iterator.next()).getUserData() == bandwidth);
                    }
                    this.modifiedProperty().set(modified);
                }
            });
        }
        return this.mBandwidthButton;
    }

    private TextField getTalkgroupField() {
        if (this.mTalkgroupField == null) {
            this.mTalkgroupField = new TextField();
            this.mTalkgroupField.setTextFormatter(this.mTalkgroupTextFormatter);
        }
        return this.mTalkgroupField;
    }

    private TextField getSquelchThresholdField() {
        if (this.mSquelchThresholdField == null) {
            this.mSquelchThresholdField = new TextField();
            this.mSquelchThresholdField.setTextFormatter((TextFormatter)this.mSquelchTextFormatter);
            this.mSquelchTextFormatter.valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSquelchThresholdField;
    }

    private ToggleSwitch getSquelchAutoTrackSwitch() {
        if (this.mSquelchAutoTrackSwitch == null) {
            this.mSquelchAutoTrackSwitch = new ToggleSwitch();
            this.mSquelchAutoTrackSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSquelchAutoTrackSwitch;
    }

    private void updateTextFormatter(int value) {
        IntegerFormat format;
        if (this.mTalkgroupTextFormatter != null) {
            this.mTalkgroupTextFormatter.valueProperty().removeListener((ChangeListener)this.mTalkgroupValueChangeListener);
        }
        if ((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(Protocol.NBFM)) == null) {
            format = IntegerFormat.DECIMAL;
        }
        if (format == IntegerFormat.DECIMAL) {
            this.mTalkgroupTextFormatter = this.mDecimalFormatter;
            this.getTalkgroupField().setTooltip(new Tooltip("1 - 65,535"));
        } else {
            this.mTalkgroupTextFormatter = this.mDecimalFormatter;
            this.getTalkgroupField().setTooltip(new Tooltip("1 - FFFF"));
        }
        this.mTalkgroupTextFormatter.setValue((Object)value);
        this.getTalkgroupField().setTextFormatter(this.mTalkgroupTextFormatter);
        this.mTalkgroupTextFormatter.valueProperty().addListener((ChangeListener)this.mTalkgroupValueChangeListener);
    }

    private ToggleSwitch getBasebandRecordSwitch() {
        if (this.mBasebandRecordSwitch == null) {
            this.mBasebandRecordSwitch = new ToggleSwitch();
            this.mBasebandRecordSwitch.setDisable(true);
            this.mBasebandRecordSwitch.setTextAlignment(TextAlignment.RIGHT);
            this.mBasebandRecordSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mBasebandRecordSwitch;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        if (config instanceof DecodeConfigNBFM) {
            this.getBandwidthButton().setDisable(false);
            DecodeConfigNBFM decodeConfigNBFM = (DecodeConfigNBFM)config;
            DecodeConfigAnalog.Bandwidth bandwidth = decodeConfigNBFM.getBandwidth() != null ? decodeConfigNBFM.getBandwidth() : DecodeConfigAnalog.Bandwidth.BW_12_5;
            Iterator iterator = this.getBandwidthButton().getToggleGroup().getToggles().iterator();
            while (iterator.hasNext()) {
                Toggle toggle;
                toggle.setSelected((toggle = (Toggle)iterator.next()).getUserData() == bandwidth);
            }
            this.updateTextFormatter(decodeConfigNBFM.getTalkgroup());
            this.getSquelchThresholdField().setDisable(false);
            this.mSquelchTextFormatter.setValue(decodeConfigNBFM.getSquelchThreshold());
            this.getSquelchAutoTrackSwitch().setDisable(false);
            this.getSquelchAutoTrackSwitch().setSelected(decodeConfigNBFM.isSquelchAutoTrack());
            this.getAudioFilterEnable().setDisable(false);
            this.getAudioFilterEnable().setSelected(decodeConfigNBFM.isAudioFilter());
        } else {
            this.getBandwidthButton().setDisable(true);
            for (Toggle toggle : this.getBandwidthButton().getToggleGroup().getToggles()) {
                toggle.setSelected(false);
            }
            this.updateTextFormatter(0);
            this.getTalkgroupField().setDisable(true);
            this.getSquelchThresholdField().setDisable(true);
            this.getSquelchAutoTrackSwitch().setDisable(true);
            this.getSquelchAutoTrackSwitch().setSelected(false);
            this.getAudioFilterEnable().setDisable(true);
            this.getAudioFilterEnable().setSelected(false);
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigNBFM config = ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigNBFM ? (DecodeConfigNBFM)((Channel)this.getItem()).getDecodeConfiguration() : new DecodeConfigNBFM();
        DecodeConfigAnalog.Bandwidth bandwidth = DecodeConfigAnalog.Bandwidth.BW_12_5;
        if (this.getBandwidthButton().getToggleGroup().getSelectedToggle() != null) {
            bandwidth = (DecodeConfigAnalog.Bandwidth)((Object)this.getBandwidthButton().getToggleGroup().getSelectedToggle().getUserData());
        }
        config.setBandwidth(bandwidth);
        Integer talkgroup = (Integer)this.mTalkgroupTextFormatter.getValue();
        if (talkgroup == null) {
            talkgroup = 1;
        }
        config.setTalkgroup(talkgroup);
        config.setSquelchThreshold((Integer)this.mSquelchTextFormatter.getValue());
        config.setSquelchAutoTrack(this.getSquelchAutoTrackSwitch().isSelected());
        config.setAudioFilter(this.getAudioFilterEnable().isSelected());
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
        this.getAuxDecoderConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
        this.getAuxDecoderConfigurationEditor().save();
        if (((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem()).getAuxDecoders().isEmpty()) {
            ((Channel)this.getItem()).setAuxDecodeConfiguration(null);
        } else {
            ((Channel)this.getItem()).setAuxDecodeConfiguration((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        if (config != null) {
            this.getBasebandRecordSwitch().setDisable(false);
            this.getBasebandRecordSwitch().selectedProperty().set(config.contains(RecorderType.BASEBAND));
        } else {
            this.getBasebandRecordSwitch().selectedProperty().set(false);
            this.getBasebandRecordSwitch().setDisable(true);
        }
    }

    @Override
    protected void saveRecordConfiguration() {
        RecordConfiguration config = new RecordConfiguration();
        if (this.getBasebandRecordSwitch().selectedProperty().get()) {
            config.addRecorder(RecorderType.BASEBAND);
        }
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }

    public class TalkgroupValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            NBFMConfigurationEditor.this.modifiedProperty().set(true);
        }
    }
}

