/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.channelMap.ViewChannelMapEditorRequest;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.mpt1327.DecodeConfigMPT1327;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPT1327ConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(MPT1327ConfigurationEditor.class);
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;
    private ComboBox<ChannelMap> mChannelMapComboBox;
    private Button mChannelMapEditButton;
    private Spinner<Integer> mTrafficChannelPoolSizeSpinner;
    private Spinner<Integer> mCallTimeoutSpinner;

    public MPT1327ConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.MPT1327;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: MPT-1327");
            this.mDecoderPane.setExpanded(true);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            Label channelMapLabel = new Label("Channel Map");
            GridPane.setHalignment((Node)channelMapLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)channelMapLabel, (int)0, (int)0);
            gridPane.getChildren().add((Object)channelMapLabel);
            GridPane.setConstraints(this.getChannelMapComboBox(), (int)1, (int)0, (int)2, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.SOMETIMES);
            gridPane.getChildren().add(this.getChannelMapComboBox());
            GridPane.setConstraints((Node)this.getChannelMapEditButton(), (int)3, (int)0);
            gridPane.getChildren().add((Object)this.getChannelMapEditButton());
            Label poolSizeLabel = new Label("Max Traffic Channels");
            GridPane.setHalignment((Node)poolSizeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)poolSizeLabel, (int)0, (int)1);
            gridPane.getChildren().add((Object)poolSizeLabel);
            GridPane.setConstraints(this.getTrafficChannelPoolSizeSpinner(), (int)1, (int)1);
            gridPane.getChildren().add(this.getTrafficChannelPoolSizeSpinner());
            Label callTimeoutLabel = new Label("Call Timeout Seconds");
            GridPane.setHalignment((Node)callTimeoutLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)callTimeoutLabel, (int)2, (int)1);
            gridPane.getChildren().add((Object)callTimeoutLabel);
            GridPane.setConstraints(this.getCallTimeoutSpinner(), (int)3, (int)1);
            gridPane.getChildren().add(this.getCallTimeoutSpinner());
            this.mDecoderPane.setContent((Node)gridPane);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager, 500, 2000, 500);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            types.add(EventLogType.TRAFFIC_CALL_EVENT);
            types.add(EventLogType.TRAFFIC_DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            types.add(RecorderType.DEMODULATED_BIT_STREAM);
            types.add(RecorderType.TRAFFIC_BASEBAND);
            types.add(RecorderType.TRAFFIC_DEMODULATED_BIT_STREAM);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    private ComboBox<ChannelMap> getChannelMapComboBox() {
        if (this.mChannelMapComboBox == null) {
            this.mChannelMapComboBox = new ComboBox();
            this.mChannelMapComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mChannelMapComboBox.setDisable(true);
            this.mChannelMapComboBox.setTooltip(new Tooltip("Select a channel map to use for this system"));
            this.mChannelMapComboBox.setItems(this.getPlaylistManager().getChannelMapModel().getChannelMaps());
            this.mChannelMapComboBox.setDisable(true);
            this.mChannelMapComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mChannelMapComboBox;
    }

    private Button getChannelMapEditButton() {
        if (this.mChannelMapEditButton == null) {
            this.mChannelMapEditButton = new Button("Channel Map Editor");
            this.mChannelMapEditButton.setTooltip(new Tooltip("Open the channel map editor to add/edit maps"));
            this.mChannelMapEditButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    String channelMapName = null;
                    if (MPT1327ConfigurationEditor.this.getChannelMapComboBox().getSelectionModel().getSelectedItem() != null) {
                        channelMapName = ((ChannelMap)MPT1327ConfigurationEditor.this.getChannelMapComboBox().getSelectionModel().getSelectedItem()).getName();
                    }
                    MyEventBus.getGlobalEventBus().post((Object)new ViewChannelMapEditorRequest(channelMapName));
                }
            });
        }
        return this.mChannelMapEditButton;
    }

    private Spinner<Integer> getTrafficChannelPoolSizeSpinner() {
        if (this.mTrafficChannelPoolSizeSpinner == null) {
            this.mTrafficChannelPoolSizeSpinner = new Spinner();
            this.mTrafficChannelPoolSizeSpinner.setDisable(true);
            this.mTrafficChannelPoolSizeSpinner.setTooltip(new Tooltip("Maximum number of traffic channels that can be created by the decoder"));
            this.mTrafficChannelPoolSizeSpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 50);
            this.mTrafficChannelPoolSizeSpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mTrafficChannelPoolSizeSpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mTrafficChannelPoolSizeSpinner;
    }

    private Spinner<Integer> getCallTimeoutSpinner() {
        if (this.mCallTimeoutSpinner == null) {
            this.mCallTimeoutSpinner = new Spinner();
            this.mCallTimeoutSpinner.setDisable(true);
            this.mCallTimeoutSpinner.setTooltip(new Tooltip("Maximum call limit in seconds"));
            this.mCallTimeoutSpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 180);
            this.mCallTimeoutSpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mCallTimeoutSpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mCallTimeoutSpinner;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        this.getChannelMapComboBox().setDisable(config == null);
        this.getCallTimeoutSpinner().setDisable(config == null);
        this.getTrafficChannelPoolSizeSpinner().setDisable(config == null);
        this.getChannelMapComboBox().getSelectionModel().select(null);
        if (config instanceof DecodeConfigMPT1327) {
            DecodeConfigMPT1327 decodeConfigMPT1327 = (DecodeConfigMPT1327)config;
            String channelMapName = decodeConfigMPT1327.getChannelMapName();
            if (channelMapName != null) {
                for (ChannelMap channelMap : this.getChannelMapComboBox().getItems()) {
                    if (!channelMap.getName().contentEquals(channelMapName)) continue;
                    this.getChannelMapComboBox().getSelectionModel().select((Object)channelMap);
                }
            }
            int callTimeout = decodeConfigMPT1327.getCallTimeoutSeconds();
            this.getCallTimeoutSpinner().getValueFactory().setValue((Object)callTimeout);
            int channelPoolSize = decodeConfigMPT1327.getTrafficChannelPoolSize();
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)channelPoolSize);
        } else if (config != null) {
            this.getCallTimeoutSpinner().getValueFactory().setValue((Object)45);
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)3);
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigMPT1327 config = ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigMPT1327 ? (DecodeConfigMPT1327)((Channel)this.getItem()).getDecodeConfiguration() : new DecodeConfigMPT1327();
        config.setCallTimeoutSeconds((Integer)this.getCallTimeoutSpinner().getValue());
        config.setTrafficChannelPoolSize((Integer)this.getTrafficChannelPoolSizeSpinner().getValue());
        ChannelMap selected = (ChannelMap)this.getChannelMapComboBox().getSelectionModel().getSelectedItem();
        if (selected != null) {
            config.setChannelMapName(selected.getName());
        } else {
            config.setChannelMapName(null);
        }
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }
}

