/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.decoder.AuxDecoderConfigurationEditor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.ltrstandard.DecodeConfigLTRStandard;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.SegmentedButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(LTRConfigurationEditor.class);
    private TitledPane mAuxDecoderPane;
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SegmentedButton mDirectionButton;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private AuxDecoderConfigurationEditor mAuxDecoderConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;

    public LTRConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getAuxDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LTR;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: LTR");
            this.mDecoderPane.setExpanded(false);
            this.mDecoderPane.expandedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue() && this.getDirectionButton().getToggleGroup().getSelectedToggle() == null && ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigLTRStandard) {
                    DecodeConfigLTRStandard decodeConfig = (DecodeConfigLTRStandard)((Channel)this.getItem()).getDecodeConfiguration();
                    MessageDirection direction = decodeConfig.getMessageDirection();
                    if (direction == null) {
                        direction = MessageDirection.OSW;
                    }
                    boolean modified = this.modifiedProperty().get();
                    Iterator iterator = this.getDirectionButton().getToggleGroup().getToggles().iterator();
                    while (iterator.hasNext()) {
                        Toggle toggle;
                        toggle.setSelected((toggle = (Toggle)iterator.next()).getUserData() == direction);
                    }
                    this.modifiedProperty().set(modified);
                }
            });
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            Label directionLabel = new Label("Direction");
            GridPane.setHalignment((Node)directionLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)directionLabel, (int)0, (int)0);
            gridPane.getChildren().add((Object)directionLabel);
            GridPane.setConstraints((Node)this.getDirectionButton(), (int)1, (int)0);
            gridPane.getChildren().add((Object)this.getDirectionButton());
            Label instructions = new Label("OSW: repeater output signaling (default).  ISW: repeater input signaling");
            GridPane.setConstraints((Node)instructions, (int)2, (int)0);
            gridPane.getChildren().addAll((Object[])new Node[]{instructions});
            this.mDecoderPane.setContent((Node)gridPane);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getAuxDecoderPane() {
        if (this.mAuxDecoderPane == null) {
            this.mAuxDecoderPane = new TitledPane("Additional Decoders", (Node)this.getAuxDecoderConfigurationEditor());
            this.mAuxDecoderPane.setExpanded(false);
        }
        return this.mAuxDecoderPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private AuxDecoderConfigurationEditor getAuxDecoderConfigurationEditor() {
        if (this.mAuxDecoderConfigurationEditor == null) {
            ArrayList<DecoderType> types = new ArrayList<DecoderType>();
            types.add(DecoderType.FLEETSYNC2);
            types.add(DecoderType.MDC1200);
            this.mAuxDecoderConfigurationEditor = new AuxDecoderConfigurationEditor(types);
            this.mAuxDecoderConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mAuxDecoderConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAuxDecoderConfigurationEditor;
    }

    private SegmentedButton getDirectionButton() {
        if (this.mDirectionButton == null) {
            this.mDirectionButton = new SegmentedButton();
            this.mDirectionButton.getStyleClass().add((Object)"dark");
            this.mDirectionButton.setDisable(true);
            for (MessageDirection messageDirection : MessageDirection.ORDERED_VALUES) {
                ToggleButton toggleButton = new ToggleButton(messageDirection.name());
                toggleButton.setTooltip(new Tooltip(messageDirection.toString()));
                toggleButton.setUserData((Object)messageDirection);
                this.mDirectionButton.getButtons().add((Object)toggleButton);
            }
            this.mDirectionButton.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mDirectionButton;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        if (config instanceof DecodeConfigLTRStandard) {
            this.getDirectionButton().setDisable(false);
            DecodeConfigLTRStandard decodeConfig = (DecodeConfigLTRStandard)config;
            MessageDirection direction = decodeConfig.getMessageDirection();
            if (direction == null) {
                direction = MessageDirection.OSW;
            }
            Iterator iterator = this.getDirectionButton().getToggleGroup().getToggles().iterator();
            while (iterator.hasNext()) {
                Toggle toggle;
                toggle.setSelected((toggle = (Toggle)iterator.next()).getUserData() == direction);
            }
        } else {
            this.getDirectionButton().setDisable(true);
            for (Toggle toggle : this.getDirectionButton().getToggleGroup().getToggles()) {
                toggle.setSelected(false);
            }
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigLTRStandard config = ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigLTRStandard ? (DecodeConfigLTRStandard)((Channel)this.getItem()).getDecodeConfiguration() : new DecodeConfigLTRStandard();
        MessageDirection messageDirection = MessageDirection.OSW;
        if (this.getDirectionButton().getToggleGroup().getSelectedToggle() != null) {
            messageDirection = (MessageDirection)((Object)this.getDirectionButton().getToggleGroup().getSelectedToggle().getUserData());
        }
        config.setMessageDirection(messageDirection);
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
        this.getAuxDecoderConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
        this.getAuxDecoderConfigurationEditor().save();
        if (((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem()).getAuxDecoders().isEmpty()) {
            ((Channel)this.getItem()).setAuxDecodeConfiguration(null);
        } else {
            ((Channel)this.getItem()).setAuxDecodeConfiguration((AuxDecodeConfiguration)this.getAuxDecoderConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }
}

