/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyField;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(DMRConfigurationEditor.class);
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;
    private ToggleSwitch mIgnoreDataCallsButton;
    private ToggleSwitch mIgnoreCRCChecksumsButton;
    private ToggleSwitch mUseCompressedTalkgroupsToggle;
    private Spinner<Integer> mTrafficChannelPoolSizeSpinner;
    private TableView<TimeslotFrequency> mTimeslotFrequencyTable;
    private IntegerTextField mLogicalChannelNumberField;
    private FrequencyField mDownlinkFrequencyField;
    private Button mAddTimeslotFrequencyButton;
    private Button mDeleteTimeslotFrequencyButton;
    private Spinner<Integer> mChannelRotationDelaySpinner;

    public DMRConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.DMR;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: DMR");
            this.mDecoderPane.setExpanded(true);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            int row = 0;
            Label poolSizeLabel = new Label("Max Traffic Channels");
            GridPane.setHalignment((Node)poolSizeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)poolSizeLabel, (int)0, (int)row);
            gridPane.getChildren().add((Object)poolSizeLabel);
            GridPane.setConstraints(this.getTrafficChannelPoolSizeSpinner(), (int)1, (int)row);
            gridPane.getChildren().add(this.getTrafficChannelPoolSizeSpinner());
            GridPane.setConstraints((Node)this.getIgnoreDataCallsButton(), (int)2, (int)row);
            gridPane.getChildren().add((Object)this.getIgnoreDataCallsButton());
            Label ignoreDataLabel = new Label("Ignore Data Calls");
            GridPane.setHalignment((Node)ignoreDataLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)ignoreDataLabel, (int)3, (int)row);
            gridPane.getChildren().add((Object)ignoreDataLabel);
            GridPane.setConstraints((Node)this.getIgnoreCRCChecksumsButton(), (int)4, (int)row);
            gridPane.getChildren().add((Object)this.getIgnoreCRCChecksumsButton());
            Label ignoreCRCLabel = new Label("Ignore CRC Checksums (RAS)");
            GridPane.setHalignment((Node)ignoreCRCLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)ignoreCRCLabel, (int)5, (int)row);
            gridPane.getChildren().add((Object)ignoreCRCLabel);
            GridPane.setConstraints((Node)this.getUseCompressedTalkgroupsToggle(), (int)6, (int)row);
            gridPane.getChildren().add((Object)this.getUseCompressedTalkgroupsToggle());
            Label useCompressedTalkgroupsLabel = new Label("Use Compressed Talkgroups");
            GridPane.setHalignment((Node)useCompressedTalkgroupsLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)useCompressedTalkgroupsLabel, (int)7, (int)row);
            gridPane.getChildren().add((Object)useCompressedTalkgroupsLabel);
            Label timeslotTableLabel = new Label("Logical Channel Number (LCN) to Frequency Map. Required for: Connect Plus and Tier-III systems that don't use absolute frequencies.  LSN = Logical Slot Number");
            GridPane.setHalignment((Node)timeslotTableLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)timeslotTableLabel, (int)0, (int)(++row), (int)6, (int)1);
            gridPane.getChildren().add((Object)timeslotTableLabel);
            GridPane.setConstraints(this.getTimeslotTable(), (int)0, (int)(++row), (int)6, (int)3);
            gridPane.getChildren().add(this.getTimeslotTable());
            VBox buttonsBox = new VBox();
            buttonsBox.setAlignment(Pos.CENTER);
            buttonsBox.setSpacing(10.0);
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getAddTimeslotFrequencyButton(), this.getDeleteTimeslotFrequencyButton()});
            GridPane.setConstraints((Node)buttonsBox, (int)6, (int)row, (int)1, (int)3);
            gridPane.getChildren().addAll((Object[])new Node[]{buttonsBox});
            row += 3;
            HBox editorBox = new HBox();
            editorBox.setAlignment(Pos.CENTER_LEFT);
            editorBox.setSpacing(5.0);
            Label lcnLabel = new Label("LCN");
            editorBox.getChildren().addAll((Object[])new Node[]{lcnLabel, this.getLogicalChannelNumberField()});
            Label downlinkLabel = new Label("Frequency (MHz)");
            downlinkLabel.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
            editorBox.getChildren().addAll((Object[])new Node[]{downlinkLabel, this.getDownlinkFrequencyField()});
            GridPane.setConstraints((Node)editorBox, (int)0, (int)row, (int)4, (int)1);
            gridPane.getChildren().add((Object)editorBox);
            this.mDecoderPane.setContent((Node)gridPane);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager, 200, 2000, 500);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            types.add(EventLogType.TRAFFIC_CALL_EVENT);
            types.add(EventLogType.TRAFFIC_DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private TableView<TimeslotFrequency> getTimeslotTable() {
        if (this.mTimeslotFrequencyTable == null) {
            this.mTimeslotFrequencyTable = new TableView(FXCollections.observableArrayList(TimeslotFrequency.extractor()));
            this.mTimeslotFrequencyTable.setPrefHeight(100.0);
            TableColumn numberColumn = new TableColumn("LCN");
            numberColumn.setPrefWidth(75.0);
            numberColumn.setCellValueFactory(cellData -> ((TimeslotFrequency)cellData.getValue()).getNumberProperty());
            this.mTimeslotFrequencyTable.getColumns().addAll((Object[])new TableColumn[]{numberColumn});
            this.mTimeslotFrequencyTable.getSortOrder().add((Object)numberColumn);
            TableColumn downlinkColumn = new TableColumn("Frequency (MHz)");
            downlinkColumn.setCellValueFactory(cellData -> ((TimeslotFrequency)cellData.getValue()).getDownlinkMHz());
            downlinkColumn.setPrefWidth(150.0);
            this.mTimeslotFrequencyTable.getColumns().addAll((Object[])new TableColumn[]{downlinkColumn});
            TableColumn lsnColumn = new TableColumn("IDs (TS1/TS2)");
            lsnColumn.setPrefWidth(225.0);
            lsnColumn.setCellValueFactory((Callback)new PropertyValueFactory("logicalSlotNumbers"));
            this.mTimeslotFrequencyTable.getColumns().addAll((Object[])new TableColumn[]{lsnColumn});
            this.mTimeslotFrequencyTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setTimeslot((TimeslotFrequency)newValue));
        }
        return this.mTimeslotFrequencyTable;
    }

    private void setTimeslot(TimeslotFrequency timeslot) {
        boolean modified = this.modifiedProperty().get();
        this.getLogicalChannelNumberField().setDisable(timeslot == null);
        this.getDownlinkFrequencyField().setDisable(timeslot == null);
        this.getDeleteTimeslotFrequencyButton().setDisable(timeslot == null);
        if (timeslot != null) {
            this.getLogicalChannelNumberField().set(timeslot.getNumber());
            this.getDownlinkFrequencyField().set(timeslot.getDownlinkFrequency());
        } else {
            this.getLogicalChannelNumberField().set(0);
            this.getDownlinkFrequencyField().set(0L);
        }
        this.modifiedProperty().set(modified);
    }

    private Button getAddTimeslotFrequencyButton() {
        if (this.mAddTimeslotFrequencyButton == null) {
            this.mAddTimeslotFrequencyButton = new Button("Add");
            this.mAddTimeslotFrequencyButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddTimeslotFrequencyButton.setOnAction(event -> this.addTimeslot());
        }
        return this.mAddTimeslotFrequencyButton;
    }

    private void addTimeslot() {
        int lsn;
        for (lsn = 1; this.hasLSN(lsn) && lsn <= 64; ++lsn) {
        }
        TimeslotFrequency timeslotFrequency = new TimeslotFrequency();
        timeslotFrequency.setNumber(lsn);
        this.getTimeslotTable().getItems().add((Object)timeslotFrequency);
        this.getTimeslotTable().scrollTo((Object)timeslotFrequency);
        this.getTimeslotTable().getSelectionModel().select((Object)timeslotFrequency);
        this.modifiedProperty().set(true);
    }

    private boolean hasLSN(int lsn) {
        for (TimeslotFrequency timeslotFrequency : this.getTimeslotTable().getItems()) {
            if (timeslotFrequency.getNumber() != lsn) continue;
            return true;
        }
        return false;
    }

    private Button getDeleteTimeslotFrequencyButton() {
        if (this.mDeleteTimeslotFrequencyButton == null) {
            this.mDeleteTimeslotFrequencyButton = new Button("Delete");
            this.mDeleteTimeslotFrequencyButton.setDisable(true);
            this.mDeleteTimeslotFrequencyButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteTimeslotFrequencyButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TimeslotFrequency selected = (TimeslotFrequency)DMRConfigurationEditor.this.getTimeslotTable().getSelectionModel().getSelectedItem();
                    if (selected != null) {
                        DMRConfigurationEditor.this.getTimeslotTable().getItems().remove((Object)selected);
                        DMRConfigurationEditor.this.modifiedProperty().set(true);
                    }
                }
            });
        }
        return this.mDeleteTimeslotFrequencyButton;
    }

    private IntegerTextField getLogicalChannelNumberField() {
        if (this.mLogicalChannelNumberField == null) {
            this.mLogicalChannelNumberField = new IntegerTextField();
            this.mLogicalChannelNumberField.setDisable(true);
            this.mLogicalChannelNumberField.setPrefWidth(65.0);
            this.mLogicalChannelNumberField.textProperty().addListener((observable, oldValue, newValue) -> {
                Integer value;
                TimeslotFrequency selected = (TimeslotFrequency)this.getTimeslotTable().getSelectionModel().getSelectedItem();
                if (selected != null && (value = this.mLogicalChannelNumberField.get()) != null) {
                    selected.setNumber(value);
                }
                this.modifiedProperty().set(true);
            });
        }
        return this.mLogicalChannelNumberField;
    }

    private FrequencyField getDownlinkFrequencyField() {
        if (this.mDownlinkFrequencyField == null) {
            this.mDownlinkFrequencyField = new FrequencyField();
            this.mDownlinkFrequencyField.setDisable(true);
            this.mDownlinkFrequencyField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TimeslotFrequency selected = (TimeslotFrequency)DMRConfigurationEditor.this.getTimeslotTable().getSelectionModel().getSelectedItem();
                    if (selected != null) {
                        selected.setDownlinkFrequency(DMRConfigurationEditor.this.mDownlinkFrequencyField.get());
                    }
                    DMRConfigurationEditor.this.modifiedProperty().set(true);
                }
            });
        }
        return this.mDownlinkFrequencyField;
    }

    private ToggleSwitch getIgnoreDataCallsButton() {
        if (this.mIgnoreDataCallsButton == null) {
            this.mIgnoreDataCallsButton = new ToggleSwitch();
            this.mIgnoreDataCallsButton.setDisable(true);
            this.mIgnoreDataCallsButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mIgnoreDataCallsButton;
    }

    private ToggleSwitch getIgnoreCRCChecksumsButton() {
        if (this.mIgnoreCRCChecksumsButton == null) {
            this.mIgnoreCRCChecksumsButton = new ToggleSwitch();
            this.mIgnoreCRCChecksumsButton.setDisable(true);
            this.mIgnoreCRCChecksumsButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mIgnoreCRCChecksumsButton;
    }

    private ToggleSwitch getUseCompressedTalkgroupsToggle() {
        if (this.mUseCompressedTalkgroupsToggle == null) {
            this.mUseCompressedTalkgroupsToggle = new ToggleSwitch();
            this.mUseCompressedTalkgroupsToggle.setTooltip(new Tooltip("Use Compressed Talkgroups.  This is only for Hytera Tier-III Trunked Systems"));
            this.mUseCompressedTalkgroupsToggle.setDisable(true);
            this.mUseCompressedTalkgroupsToggle.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mUseCompressedTalkgroupsToggle;
    }

    private Spinner<Integer> getTrafficChannelPoolSizeSpinner() {
        if (this.mTrafficChannelPoolSizeSpinner == null) {
            this.mTrafficChannelPoolSizeSpinner = new Spinner();
            this.mTrafficChannelPoolSizeSpinner.setDisable(true);
            this.mTrafficChannelPoolSizeSpinner.setTooltip(new Tooltip("Maximum number of traffic channels that can be created by the decoder"));
            this.mTrafficChannelPoolSizeSpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 50);
            this.mTrafficChannelPoolSizeSpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mTrafficChannelPoolSizeSpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mTrafficChannelPoolSizeSpinner;
    }

    private Spinner<Integer> getChannelRotationDelaySpinner() {
        if (this.mChannelRotationDelaySpinner == null) {
            this.mChannelRotationDelaySpinner = new Spinner();
            this.mChannelRotationDelaySpinner.setDisable(true);
            this.mChannelRotationDelaySpinner.setTooltip(new Tooltip("Delay on each frequency before rotating to next when seeking to next active channel frequency"));
            this.mChannelRotationDelaySpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(200, 2000, 200, 50);
            this.mChannelRotationDelaySpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mChannelRotationDelaySpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mChannelRotationDelaySpinner;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            types.add(RecorderType.DEMODULATED_BIT_STREAM);
            types.add(RecorderType.MBE_CALL_SEQUENCE);
            types.add(RecorderType.TRAFFIC_BASEBAND);
            types.add(RecorderType.TRAFFIC_DEMODULATED_BIT_STREAM);
            types.add(RecorderType.TRAFFIC_MBE_CALL_SEQUENCE);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        this.getIgnoreCRCChecksumsButton().setDisable(config == null);
        this.getIgnoreDataCallsButton().setDisable(config == null);
        this.getUseCompressedTalkgroupsToggle().setDisable(config == null);
        this.getTrafficChannelPoolSizeSpinner().setDisable(config == null);
        this.getTimeslotTable().getItems().clear();
        this.getTimeslotTable().setDisable(config == null);
        this.getAddTimeslotFrequencyButton().setDisable(config == null);
        this.getDeleteTimeslotFrequencyButton().setDisable(true);
        this.getLogicalChannelNumberField().set(0);
        this.getLogicalChannelNumberField().setDisable(true);
        this.getDownlinkFrequencyField().set(0L);
        this.getDownlinkFrequencyField().setDisable(true);
        this.getChannelRotationDelaySpinner().setDisable(config == null);
        if (config instanceof DecodeConfigDMR) {
            DecodeConfigDMR decodeConfig = (DecodeConfigDMR)config;
            this.getIgnoreDataCallsButton().setSelected(decodeConfig.getIgnoreDataCalls());
            this.getIgnoreCRCChecksumsButton().setSelected(decodeConfig.getIgnoreCRCChecksums());
            this.getUseCompressedTalkgroupsToggle().setSelected(decodeConfig.isUseCompressedTalkgroups());
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)decodeConfig.getTrafficChannelPoolSize());
            for (TimeslotFrequency timeslotFrequency : decodeConfig.getTimeslotMap()) {
                this.getTimeslotTable().getItems().add((Object)timeslotFrequency.copy());
            }
        } else {
            this.getIgnoreCRCChecksumsButton().setSelected(false);
            this.getIgnoreDataCallsButton().setSelected(false);
            this.getUseCompressedTalkgroupsToggle().setSelected(false);
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)0);
            this.getChannelRotationDelaySpinner().getValueFactory().setValue((Object)200);
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigDMR config = ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigDMR ? (DecodeConfigDMR)((Channel)this.getItem()).getDecodeConfiguration() : new DecodeConfigDMR();
        config.setIgnoreCRCChecksums(this.getIgnoreCRCChecksumsButton().isSelected());
        config.setIgnoreDataCalls(this.getIgnoreDataCallsButton().isSelected());
        config.setTrafficChannelPoolSize((Integer)this.getTrafficChannelPoolSizeSpinner().getValue());
        config.setUseCompressedTalkgroups(this.getUseCompressedTalkgroupsToggle().isSelected());
        config.setTimeslotMap(new ArrayList<TimeslotFrequency>((Collection<TimeslotFrequency>)this.getTimeslotTable().getItems()));
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }

    public class DownlinkPropertyValueFactory
    extends PropertyValueFactory<TimeslotFrequency, String> {
        private StringProperty mStringProperty = new SimpleStringProperty();

        public DownlinkPropertyValueFactory(DMRConfigurationEditor this$0) {
            super("downlinkFrequency");
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<TimeslotFrequency, String> param) {
            if (param.getValue() != null) {
                this.mStringProperty.set((Object)String.valueOf((double)((TimeslotFrequency)param.getValue()).getDownlinkFrequency() / 1000000.0));
            } else {
                this.mStringProperty.setValue(null);
            }
            return this.mStringProperty;
        }
    }

    public class FrequencyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<TimeslotFrequency, String>, ObservableValue<String>> {
        private SimpleStringProperty mFrequency = new SimpleStringProperty();
        private boolean mIsDownlink;

        public FrequencyCellValueFactory(DMRConfigurationEditor this$0, boolean isDownlink) {
            this.mIsDownlink = isDownlink;
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<TimeslotFrequency, String> param) {
            if (param.getValue() != null) {
                long frequency = this.mIsDownlink ? ((TimeslotFrequency)param.getValue()).getDownlinkFrequency() : ((TimeslotFrequency)param.getValue()).getUplinkFrequency();
                this.mFrequency.set(String.valueOf((double)frequency / 1000000.0));
            } else {
                this.mFrequency.set(null);
            }
            return this.mFrequency;
        }
    }
}

