/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.gui.playlist.channel.AMConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.DMRConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.channel.LTRConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.LTRNetConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.MPT1327ConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.NBFMConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.P25P1ConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.P25P2ConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.PassportConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelConfigurationEditorFactory {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelConfigurationEditorFactory.class);
    private static List<DecoderType> mLoggedUnrecognizedTypes = new ArrayList<DecoderType>();

    public static ChannelConfigurationEditor getEditor(DecoderType decoderType, PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        switch (decoderType) {
            case AM: {
                return new AMConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case DMR: {
                return new DMRConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case NBFM: {
                return new NBFMConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case LTR_NET: {
                return new LTRNetConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case LTR: {
                return new LTRConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case MPT1327: {
                return new MPT1327ConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case PASSPORT: {
                return new PassportConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case P25_PHASE1: {
                return new P25P1ConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
            case P25_PHASE2: {
                return new P25P2ConfigurationEditor(playlistManager, tunerManager, userPreferences, filterProcessor);
            }
        }
        if (decoderType != null && !mLoggedUnrecognizedTypes.contains((Object)decoderType)) {
            mLog.warn("Can't create channel configuration editor - unrecognized decoder type: " + String.valueOf((Object)decoderType));
            mLoggedUnrecognizedTypes.add(decoderType);
        }
        return null;
    }
}

