/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelException;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.control.MaxLengthUnaryOperator;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.util.ThreadPool;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelConfigurationEditor
extends Editor<Channel> {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelConfigurationEditor.class);
    private PlaylistManager mPlaylistManager;
    protected TunerManager mTunerManager;
    protected UserPreferences mUserPreferences;
    protected EditorModificationListener mEditorModificationListener = new EditorModificationListener();
    private Button mPlayButton;
    private TextField mSystemField;
    private TextField mSiteField;
    private TextField mNameField;
    private ComboBox<String> mAliasListComboBox;
    private Button mNewAliasListButton;
    private GridPane mTextFieldPane;
    private Button mSaveButton;
    private Button mResetButton;
    private VBox mButtonBox;
    private ScrollPane mTitledPanesScrollPane;
    private VBox mTitledPanesBox;
    private ToggleSwitch mAutoStartSwitch;
    private Spinner<Integer> mAutoStartOrderSpinner;
    private IconNode mPlayGraphicNode;
    private IconNode mStopGraphicNode;
    private ChannelProcessingMonitor mChannelProcessingMonitor = new ChannelProcessingMonitor();
    private IFilterProcessor mFilterProcessor;

    public ChannelConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        this.mPlaylistManager = playlistManager;
        this.mTunerManager = tunerManager;
        this.mUserPreferences = userPreferences;
        this.mFilterProcessor = filterProcessor;
        this.setMaxWidth(Double.MAX_VALUE);
        HBox hbox = new HBox();
        hbox.setSpacing(10.0);
        hbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        hbox.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.getTextFieldPane(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getButtonBox(), (Priority)Priority.NEVER);
        hbox.getChildren().addAll((Object[])new Node[]{this.getTextFieldPane(), this.getButtonBox()});
        VBox.setVgrow((Node)this.getTitledPanesScrollPane(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{hbox, this.getTitledPanesScrollPane()});
    }

    protected PlaylistManager getPlaylistManager() {
        return this.mPlaylistManager;
    }

    @Override
    public void dispose() {
    }

    public abstract DecoderType getDecoderType();

    @Override
    public void setItem(Channel channel) {
        if (this.getItem() != null) {
            ((Channel)this.getItem()).processingProperty().removeListener((ChangeListener)this.mChannelProcessingMonitor);
        }
        super.setItem(channel);
        if (this.getItem() != null) {
            this.setPlayButtonState(((Channel)this.getItem()).processingProperty().get());
            ((Channel)this.getItem()).processingProperty().addListener((ChangeListener)this.mChannelProcessingMonitor);
        }
        boolean disable = channel == null;
        this.getPlayButton().setDisable(disable);
        this.getSystemField().setDisable(disable);
        this.getSiteField().setDisable(disable);
        this.getNameField().setDisable(disable);
        this.getAliasListComboBox().setDisable(disable);
        this.getNewAliasListButton().setDisable(disable);
        this.getAutoStartSwitch().setDisable(disable);
        if (channel != null) {
            this.getSystemField().setText(channel.getSystem());
            this.getSiteField().setText(channel.getSite());
            this.getNameField().setText(channel.getName());
            String aliasListName = channel.getAliasListName();
            if (aliasListName != null) {
                if (!this.getAliasListComboBox().getItems().contains((Object)aliasListName)) {
                    this.mPlaylistManager.getAliasModel().addAliasList(aliasListName);
                }
                this.getAliasListComboBox().getSelectionModel().select((Object)aliasListName);
            } else {
                this.getAliasListComboBox().getSelectionModel().select(null);
            }
            this.getAutoStartSwitch().selectedProperty().set(channel.isAutoStart());
            this.getAutoStartOrderSpinner().setDisable(!channel.isAutoStart());
            Integer order = channel.getAutoStartOrder();
            this.getAutoStartOrderSpinner().getValueFactory().setValue((Object)(order != null ? order : 0));
            this.setDecoderConfiguration(channel.getDecodeConfiguration());
            SourceConfiguration sourceConfiguration = channel.getSourceConfiguration();
            if (sourceConfiguration == null) {
                sourceConfiguration = new SourceConfigTuner();
            }
            this.setSourceConfiguration(sourceConfiguration);
            AuxDecodeConfiguration auxDecodeConfiguration = channel.getAuxDecodeConfiguration();
            if (auxDecodeConfiguration == null) {
                auxDecodeConfiguration = new AuxDecodeConfiguration();
            }
            this.setAuxDecoderConfiguration(auxDecodeConfiguration);
            EventLogConfiguration eventLogConfiguration = channel.getEventLogConfiguration();
            if (eventLogConfiguration == null) {
                eventLogConfiguration = new EventLogConfiguration();
            }
            this.setEventLogConfiguration(eventLogConfiguration);
            RecordConfiguration recordConfiguration = channel.getRecordConfiguration();
            if (recordConfiguration == null) {
                recordConfiguration = new RecordConfiguration();
            }
            this.setRecordConfiguration(recordConfiguration);
        } else {
            this.getSystemField().setText(null);
            this.getSiteField().setText(null);
            this.getNameField().setText(null);
            this.getAliasListComboBox().getSelectionModel().select(null);
            this.getAutoStartSwitch().selectedProperty().set(false);
            this.getAutoStartOrderSpinner().setDisable(true);
            this.getAutoStartOrderSpinner().getValueFactory().setValue((Object)0);
            this.setDecoderConfiguration(null);
            this.setAuxDecoderConfiguration(null);
            this.setEventLogConfiguration(null);
            this.setRecordConfiguration(null);
            this.setSourceConfiguration(null);
        }
        this.modifiedProperty().setValue(Boolean.valueOf(false));
    }

    @Override
    public void save() {
        if (this.modifiedProperty().get()) {
            ((Channel)this.getItem()).setSystem(this.getSystemField().getText());
            ((Channel)this.getItem()).setSite(this.getSiteField().getText());
            ((Channel)this.getItem()).setName(" ");
            ((Channel)this.getItem()).setName(this.getNameField().getText());
            ((Channel)this.getItem()).setAliasListName((String)this.getAliasListComboBox().getSelectionModel().getSelectedItem());
            ((Channel)this.getItem()).setAutoStart(this.getAutoStartSwitch().isSelected());
            Integer order = (Integer)this.getAutoStartOrderSpinner().getValue();
            if (order == null || order < 1) {
                ((Channel)this.getItem()).setAutoStartOrder(null);
            } else {
                ((Channel)this.getItem()).setAutoStartOrder((Integer)this.getAutoStartOrderSpinner().getValue());
            }
            this.saveDecoderConfiguration();
            this.saveAuxDecoderConfiguration();
            this.saveEventLogConfiguration();
            this.saveRecordConfiguration();
            this.saveSourceConfiguration();
            this.modifiedProperty().set(false);
        }
    }

    protected abstract void setAuxDecoderConfiguration(AuxDecodeConfiguration var1);

    protected abstract void saveAuxDecoderConfiguration();

    protected abstract void setDecoderConfiguration(DecodeConfiguration var1);

    protected abstract void saveDecoderConfiguration();

    protected abstract void setEventLogConfiguration(EventLogConfiguration var1);

    protected abstract void saveEventLogConfiguration();

    protected abstract void setRecordConfiguration(RecordConfiguration var1);

    protected abstract void saveRecordConfiguration();

    protected abstract void setSourceConfiguration(SourceConfiguration var1);

    protected abstract void saveSourceConfiguration();

    private Button getPlayButton() {
        if (this.mPlayButton == null) {
            this.mPlayGraphicNode = new IconNode((IconCode)FontAwesome.PLAY);
            this.mPlayGraphicNode.setFill((Paint)Color.GREEN);
            this.mPlayGraphicNode.setIconSize((Number)24);
            this.mStopGraphicNode = new IconNode((IconCode)FontAwesome.STOP);
            this.mStopGraphicNode.setFill((Paint)Color.RED);
            this.mStopGraphicNode.setIconSize((Number)24);
            this.mPlayButton = new Button("Play");
            this.mPlayButton.setMaxWidth(Double.MAX_VALUE);
            this.mPlayButton.setMaxHeight(Double.MAX_VALUE);
            this.mPlayButton.setDisable(true);
            this.mPlayButton.setOnAction(event -> {
                if (this.getItem() != null) {
                    if (this.modifiedProperty().get()) {
                        Alert alert = new Alert(Alert.AlertType.WARNING, "Do you want to save these changes?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                        alert.setTitle("Channel Configuration Modified");
                        alert.setHeaderText("Channel configuration has unsaved changes");
                        alert.initOwner(this.getPlayButton().getScene().getWindow());
                        alert.showAndWait().ifPresent(buttonType -> {
                            if (buttonType == ButtonType.YES) {
                                this.save();
                            }
                        });
                    }
                    if (this.requiresJmbeLibrarySetup() && this.mUserPreferences.getJmbeLibraryPreference().getAlertIfMissingLibraryRequired() && !((Channel)this.getItem()).processingProperty().get()) {
                        String content = "The decoder for this channel configuration requires the (optional) JMBE library to produce audio and the JMBE library is not currently setup.  Do you want to setup the JMBE library?";
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, content, new ButtonType[]{ButtonType.YES, ButtonType.NO});
                        alert.setTitle("JMBE Library");
                        alert.setHeaderText("Setup JMBE Library?");
                        Label label = new Label(content);
                        label.setMaxWidth(Double.MAX_VALUE);
                        label.setMaxHeight(Double.MAX_VALUE);
                        label.getStyleClass().add((Object)"content");
                        label.setWrapText(true);
                        CheckBox checkBox = new CheckBox("Don't Show This Again");
                        checkBox.setOnAction(event1 -> {
                            boolean dontShowAgain = checkBox.isSelected();
                            this.mUserPreferences.getJmbeLibraryPreference().setAlertIfMissingLibraryRequired(!dontShowAgain);
                        });
                        VBox contentBox = new VBox();
                        contentBox.setPrefWidth(360.0);
                        contentBox.setSpacing(10.0);
                        contentBox.getChildren().addAll((Object[])new Node[]{label, checkBox});
                        alert.getDialogPane().setContent((Node)contentBox);
                        alert.initOwner(this.getPlayButton().getScene().getWindow());
                        Optional optionalButtonType = alert.showAndWait();
                        if (optionalButtonType.isPresent() && optionalButtonType.get() == ButtonType.YES) {
                            MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest(PreferenceEditorType.JMBE_LIBRARY));
                            return;
                        }
                    }
                    if (!((Channel)this.getItem()).processingProperty().get()) {
                        ThreadPool.CACHED.execute(() -> {
                            try {
                                this.mPlaylistManager.getChannelProcessingManager().start((Channel)this.getItem());
                            }
                            catch (ChannelException ce) {
                                mLog.error("Error starting channel [" + ((Channel)this.getItem()).getName() + "] - " + ce.getMessage());
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR, "Error: " + ce.getMessage(), new ButtonType[]{ButtonType.OK});
                                    alert.setTitle("Channel Play Error");
                                    alert.setHeaderText("Can't play channel");
                                    alert.initOwner(this.getPlayButton().getScene().getWindow());
                                    alert.showAndWait();
                                });
                            }
                        });
                    } else {
                        ThreadPool.CACHED.execute(() -> {
                            try {
                                this.mPlaylistManager.getChannelProcessingManager().stop((Channel)this.getItem());
                            }
                            catch (ChannelException ce) {
                                mLog.error("Error stopping channel [" + ((Channel)this.getItem()).getName() + "] - " + ce.getMessage());
                                Platform.runLater(() -> {
                                    Alert alert = new Alert(Alert.AlertType.ERROR, "Error: " + ce.getMessage(), new ButtonType[]{ButtonType.OK});
                                    alert.setTitle("Channel Stop Error");
                                    alert.setHeaderText("Can't stop channel");
                                    alert.initOwner(this.getPlayButton().getScene().getWindow());
                                    alert.showAndWait();
                                });
                            }
                        });
                    }
                }
            });
        }
        return this.mPlayButton;
    }

    private boolean requiresJmbeLibrarySetup() {
        return this.getItem() != null && ((Channel)this.getItem()).getDecodeConfiguration().getDecoderType().providesMBEAudioFrames() && !this.mUserPreferences.getJmbeLibraryPreference().hasJmbeLibraryPath();
    }

    private void setPlayButtonState(boolean playing) {
        if (playing) {
            this.getPlayButton().setText("Stop");
            this.getPlayButton().setGraphic((Node)this.mStopGraphicNode);
        } else {
            this.getPlayButton().setText("Play");
            this.getPlayButton().setGraphic((Node)this.mPlayGraphicNode);
        }
    }

    private ToggleSwitch getAutoStartSwitch() {
        if (this.mAutoStartSwitch == null) {
            this.mAutoStartSwitch = new ToggleSwitch();
            this.mAutoStartSwitch.setDisable(true);
            this.mAutoStartSwitch.setDisable(true);
            this.mAutoStartSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAutoStartSwitch;
    }

    private Spinner<Integer> getAutoStartOrderSpinner() {
        if (this.mAutoStartOrderSpinner == null) {
            this.mAutoStartOrderSpinner = new Spinner();
            this.mAutoStartOrderSpinner.setPrefWidth(100.0);
            this.mAutoStartOrderSpinner.setDisable(true);
            this.getAutoStartSwitch().selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    ChannelConfigurationEditor.this.getAutoStartOrderSpinner().setDisable(ChannelConfigurationEditor.this.getAutoStartSwitch().selectedProperty().getValue() == false);
                }
            });
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 99);
            this.mAutoStartOrderSpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mAutoStartOrderSpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            this.mAutoStartOrderSpinner.valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mAutoStartOrderSpinner;
    }

    protected VBox getTitledPanesBox() {
        if (this.mTitledPanesBox == null) {
            this.mTitledPanesBox = new VBox();
            this.mTitledPanesBox.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mTitledPanesBox;
    }

    private ScrollPane getTitledPanesScrollPane() {
        if (this.mTitledPanesScrollPane == null) {
            this.mTitledPanesScrollPane = new ScrollPane();
            this.mTitledPanesScrollPane.setFitToWidth(true);
            this.mTitledPanesScrollPane.setContent((Node)this.getTitledPanesBox());
        }
        return this.mTitledPanesScrollPane;
    }

    private GridPane getTextFieldPane() {
        if (this.mTextFieldPane == null) {
            this.mTextFieldPane = new GridPane();
            this.mTextFieldPane.setVgap(10.0);
            this.mTextFieldPane.setHgap(10.0);
            int row = 0;
            Label systemLabel = new Label("System");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)row);
            this.mTextFieldPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getSystemField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getSystemField(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add((Object)this.getSystemField());
            Label autoStartLabel = new Label("Auto-Start");
            GridPane.setHalignment((Node)autoStartLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)autoStartLabel, (int)2, (int)row);
            this.mTextFieldPane.getChildren().add((Object)autoStartLabel);
            GridPane.setConstraints((Node)this.getAutoStartSwitch(), (int)3, (int)row);
            GridPane.setHalignment((Node)this.getAutoStartSwitch(), (HPos)HPos.LEFT);
            this.mTextFieldPane.getChildren().add((Object)this.getAutoStartSwitch());
            GridPane.setConstraints((Node)this.getPlayButton(), (int)4, (int)row, (int)1, (int)2);
            this.mTextFieldPane.getChildren().add((Object)this.getPlayButton());
            Label siteLabel = new Label("Site");
            GridPane.setHalignment((Node)siteLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)siteLabel, (int)0, (int)(++row));
            this.mTextFieldPane.getChildren().add((Object)siteLabel);
            GridPane.setConstraints((Node)this.getSiteField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getSiteField(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add((Object)this.getSiteField());
            Label autoStartOrderLabel = new Label("Start Order");
            GridPane.setHalignment((Node)autoStartOrderLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)autoStartOrderLabel, (int)2, (int)row);
            this.mTextFieldPane.getChildren().add((Object)autoStartOrderLabel);
            GridPane.setConstraints(this.getAutoStartOrderSpinner(), (int)3, (int)row);
            GridPane.setHalignment(this.getAutoStartOrderSpinner(), (HPos)HPos.LEFT);
            this.mTextFieldPane.getChildren().add(this.getAutoStartOrderSpinner());
            Label nameLabel = new Label("Name");
            GridPane.setHalignment((Node)nameLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)nameLabel, (int)0, (int)(++row));
            this.mTextFieldPane.getChildren().add((Object)nameLabel);
            GridPane.setConstraints((Node)this.getNameField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getNameField(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add((Object)this.getNameField());
            Label aliasListLabel = new Label("Alias List");
            GridPane.setHalignment((Node)aliasListLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)aliasListLabel, (int)2, (int)row);
            this.mTextFieldPane.getChildren().add((Object)aliasListLabel);
            GridPane.setConstraints(this.getAliasListComboBox(), (int)3, (int)row);
            GridPane.setHgrow(this.getAliasListComboBox(), (Priority)Priority.ALWAYS);
            this.mTextFieldPane.getChildren().add(this.getAliasListComboBox());
            GridPane.setConstraints((Node)this.getNewAliasListButton(), (int)4, (int)row);
            this.mTextFieldPane.getChildren().add((Object)this.getNewAliasListButton());
        }
        return this.mTextFieldPane;
    }

    protected TextField getSystemField() {
        if (this.mSystemField == null) {
            this.mSystemField = new TextField();
            this.mSystemField.setDisable(true);
            this.mSystemField.setMaxWidth(Double.MAX_VALUE);
            this.mSystemField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mSystemField;
    }

    protected TextField getSiteField() {
        if (this.mSiteField == null) {
            this.mSiteField = new TextField();
            this.mSiteField.setDisable(true);
            this.mSiteField.setMaxWidth(Double.MAX_VALUE);
            this.mSiteField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mSiteField;
    }

    protected TextField getNameField() {
        if (this.mNameField == null) {
            this.mNameField = new TextField();
            this.mNameField.setDisable(true);
            this.mNameField.setMaxWidth(Double.MAX_VALUE);
            this.mNameField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mNameField;
    }

    protected ComboBox<String> getAliasListComboBox() {
        if (this.mAliasListComboBox == null) {
            Predicate<String> filterPredicate = s -> !s.contentEquals("(No Alias List)");
            FilteredList filteredChannelList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasListNames(), filterPredicate);
            this.mAliasListComboBox = new ComboBox((ObservableList)filteredChannelList);
            this.mAliasListComboBox.setPrefWidth(150.0);
            this.mAliasListComboBox.setDisable(true);
            this.mAliasListComboBox.setEditable(false);
            this.mAliasListComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mAliasListComboBox.setOnAction(event -> this.modifiedProperty().set(true));
        }
        return this.mAliasListComboBox;
    }

    private Button getNewAliasListButton() {
        if (this.mNewAliasListButton == null) {
            this.mNewAliasListButton = new Button("New Alias List");
            this.mNewAliasListButton.setDisable(true);
            this.mNewAliasListButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TextInputDialog dialog = new TextInputDialog();
                    dialog.setTitle("Create New Alias List");
                    dialog.setHeaderText("Please enter an alias list name (max 25 chars).");
                    dialog.setContentText("Name:");
                    dialog.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)new MaxLengthUnaryOperator(25)));
                    Optional result = dialog.showAndWait();
                    result.ifPresent(s -> {
                        String name = (String)result.get();
                        if (name != null && !name.isEmpty()) {
                            name = name.trim();
                            ChannelConfigurationEditor.this.mPlaylistManager.getAliasModel().addAliasList(name);
                            ChannelConfigurationEditor.this.getAliasListComboBox().getSelectionModel().select((Object)name);
                        }
                    });
                }
            });
        }
        return this.mNewAliasListButton;
    }

    private VBox getButtonBox() {
        if (this.mButtonBox == null) {
            this.mButtonBox = new VBox();
            this.mButtonBox.setSpacing(10.0);
            this.mButtonBox.getChildren().addAll((Object[])new Node[]{this.getSaveButton(), this.getResetButton()});
        }
        return this.mButtonBox;
    }

    private Button getSaveButton() {
        if (this.mSaveButton == null) {
            this.mSaveButton = new Button("     Save     ");
            this.mSaveButton.setMaxWidth(Double.MAX_VALUE);
            this.mSaveButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
            this.mSaveButton.setOnAction(event -> {
                if (this.mFilterProcessor != null) {
                    this.mFilterProcessor.clearFilter();
                    this.save();
                    this.mFilterProcessor.restoreFilter();
                } else {
                    this.save();
                }
                if (((Channel)this.getItem()).isProcessing()) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Would you like to restart the channel?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setTitle("Restart Channel?");
                    alert.setHeaderText("Channel configuration has changed");
                    alert.initOwner(this.getPlayButton().getScene().getWindow());
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.YES) {
                        try {
                            this.mPlaylistManager.getChannelProcessingManager().stop((Channel)this.getItem());
                            this.mPlaylistManager.getChannelProcessingManager().start((Channel)this.getItem());
                        }
                        catch (ChannelException se) {
                            mLog.error("Error restarting channel", (Throwable)se);
                        }
                    }
                }
            });
        }
        return this.mSaveButton;
    }

    private Button getResetButton() {
        if (this.mResetButton == null) {
            this.mResetButton = new Button("Reset");
            this.mResetButton.setMaxWidth(Double.MAX_VALUE);
            this.mResetButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
            this.mResetButton.setOnAction(event -> {
                this.modifiedProperty().set(false);
                this.setItem((Channel)this.getItem());
            });
        }
        return this.mResetButton;
    }

    public class EditorModificationListener
    implements ChangeListener<String> {
        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            ChannelConfigurationEditor.this.modifiedProperty().set(true);
        }
    }

    public class ChannelProcessingMonitor
    implements ChangeListener<Boolean> {
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (ChannelConfigurationEditor.this.getItem() != null && newValue != null) {
                ChannelConfigurationEditor.this.setPlayButtonState(newValue);
            }
        }
    }
}

