/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.status.UnitStatusID;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitStatusEditor
extends IdentifierEditor<UnitStatusID> {
    private static final Logger mLog = LoggerFactory.getLogger(UnitStatusEditor.class);
    private TextField mUnitStatusField;
    private TextFormatter<Integer> mIntegerTextFormatter;

    public UnitStatusEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        Label valueLabel = new Label("Unit Status");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)0, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getUnitStatusField(), (int)1, (int)0);
        gridPane.getChildren().add((Object)this.getUnitStatusField());
        Label helpLabel = new Label("Format: 0 - 255");
        GridPane.setConstraints((Node)helpLabel, (int)2, (int)0);
        gridPane.getChildren().add((Object)helpLabel);
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(UnitStatusID item) {
        super.setItem(item);
        UnitStatusID unitStatus = (UnitStatusID)this.getItem();
        this.getUnitStatusField().setDisable(unitStatus == null);
        if (unitStatus != null) {
            this.getTextFormatter().setValue((Object)unitStatus.getStatus());
        } else {
            this.getTextFormatter().setValue(null);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private TextField getUnitStatusField() {
        if (this.mUnitStatusField == null) {
            this.mUnitStatusField = new TextField();
            this.mUnitStatusField.setTextFormatter(this.getTextFormatter());
        }
        return this.mUnitStatusField;
    }

    private TextFormatter<Integer> getTextFormatter() {
        if (this.mIntegerTextFormatter == null) {
            this.mIntegerTextFormatter = new IntegerFormatter(0, 255);
            this.mIntegerTextFormatter.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    if (UnitStatusEditor.this.getItem() != null) {
                        ((UnitStatusID)UnitStatusEditor.this.getItem()).setStatus(newValue != null ? newValue : 0);
                        UnitStatusEditor.this.modifiedProperty().set(true);
                    }
                }
            });
        }
        return this.mIntegerTextFormatter;
    }
}

