/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.control.LtrFormatter;
import io.github.dsheirer.gui.control.PrefixIdentFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkgroupEditor
extends IdentifierEditor<Talkgroup> {
    private static final Logger mLog = LoggerFactory.getLogger(TalkgroupEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private Label mFormatLabel;
    private TextField mTalkgroupField;
    private TextFormatter<Integer> mIntegerTextFormatter;
    private List<TalkgroupDetail> mTalkgroupDetails = new ArrayList<TalkgroupDetail>();
    private TalkgroupValueChangeListener mTalkgroupValueChangeListener = new TalkgroupValueChangeListener();

    public TalkgroupEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.loadTalkgroupDetails();
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("Talkgroup");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getTalkgroupField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getTalkgroupField());
        GridPane.setConstraints((Node)this.getFormatLabel(), (int)3, (int)0);
        gridPane.getChildren().add((Object)this.getFormatLabel());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(Talkgroup item) {
        super.setItem(item);
        Talkgroup talkgroup = (Talkgroup)this.getItem();
        this.getProtocolLabel().setDisable(talkgroup == null);
        this.getTalkgroupField().setDisable(talkgroup == null);
        if (talkgroup != null) {
            this.getProtocolLabel().setText(talkgroup.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getTalkgroupField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mIntegerTextFormatter != null) {
            this.mIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mTalkgroupValueChangeListener);
        }
        if ((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((Talkgroup)this.getItem()).getProtocol())) != null) {
            TalkgroupDetail talkgroupDetail = this.getTalkgroupDetail(((Talkgroup)this.getItem()).getProtocol(), format);
            if (talkgroupDetail != null) {
                this.mIntegerTextFormatter = talkgroupDetail.getTextFormatter();
                Integer value = this.getItem() != null ? Integer.valueOf(((Talkgroup)this.getItem()).getValue()) : null;
                this.mTalkgroupField.setTextFormatter(this.mIntegerTextFormatter);
                this.mTalkgroupField.setTooltip(new Tooltip(talkgroupDetail.getTooltip()));
                this.mIntegerTextFormatter.setValue((Object)value);
                this.mIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mTalkgroupValueChangeListener);
            } else {
                mLog.warn("Couldn't find talkgroup detail for protocol [" + String.valueOf((Object)((Talkgroup)this.getItem()).getProtocol()) + "] and format [" + String.valueOf((Object)format) + "]");
            }
            this.getFormatLabel().setText(talkgroupDetail.getTooltip());
        } else {
            this.getFormatLabel().setText(" ");
            mLog.warn("Integer format combobox does not have a selected value.");
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getFormatLabel() {
        if (this.mFormatLabel == null) {
            this.mFormatLabel = new Label(" ");
        }
        return this.mFormatLabel;
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getTalkgroupField() {
        if (this.mTalkgroupField == null) {
            this.mTalkgroupField = new TextField();
            this.mTalkgroupField.setTextFormatter(this.mIntegerTextFormatter);
        }
        return this.mTalkgroupField;
    }

    private TalkgroupDetail getTalkgroupDetail(Protocol protocol, IntegerFormat integerFormat) {
        for (TalkgroupDetail detail : this.mTalkgroupDetails) {
            if (detail.getProtocol() != protocol || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("Unable to find talkgroup editor for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "] - using default editor");
        for (TalkgroupDetail detail : this.mTalkgroupDetails) {
            if (detail.getProtocol() != Protocol.UNKNOWN || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("No Talkgroup Detail is configured for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "]");
        return null;
    }

    private void loadTalkgroupDetails() {
        this.mTalkgroupDetails.clear();
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.AM, IntegerFormat.DECIMAL, new IntegerFormatter(1, 65535), "Format: 1 - 65535"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.AM, IntegerFormat.HEXADECIMAL, new HexFormatter(1, 65535), "Format: 1 - FFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.APCO25, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.APCO25, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.DMR, IntegerFormat.DECIMAL, new IntegerFormatter(1, 0xFFFFFF), "Format: 1 - 16,777,215"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.DMR, IntegerFormat.HEXADECIMAL, new HexFormatter(1, 0xFFFFFF), "Format: 1 - FFFFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.FLEETSYNC, IntegerFormat.FORMATTED, new PrefixIdentFormatter(0, 1048575), "Format: PPP-IIII = Prefix (0-127), Ident (0-8191)"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.LTR, IntegerFormat.FORMATTED, new LtrFormatter(0, 16383), "Format: A-HH-TTT = Area (0-1), Home (1-31), Talkgroup (1-255)"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.MDC1200, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.MDC1200, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.MPT1327, IntegerFormat.FORMATTED, new PrefixIdentFormatter(0, 1048575), "Format: PPP-IIII = Prefix (0-127), Ident (0-8191)"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.NBFM, IntegerFormat.DECIMAL, new IntegerFormatter(1, 65535), "Format: 1 - 65535"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.NBFM, IntegerFormat.HEXADECIMAL, new HexFormatter(1, 65535), "Format: 1 - FFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.PASSPORT, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.PASSPORT, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.UNKNOWN, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.UNKNOWN, IntegerFormat.FORMATTED, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mTalkgroupDetails.add(new TalkgroupDetail(Protocol.UNKNOWN, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
    }

    public class TalkgroupValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (TalkgroupEditor.this.getItem() != null) {
                ((Talkgroup)TalkgroupEditor.this.getItem()).setValue(newValue != null ? newValue : 0);
                TalkgroupEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public static class TalkgroupDetail {
        private Protocol mProtocol;
        private IntegerFormat mIntegerFormat;
        private TextFormatter<Integer> mTextFormatter;
        private String mTooltip;

        public TalkgroupDetail(Protocol protocol, IntegerFormat integerFormat, TextFormatter<Integer> textFormatter, String tooltip) {
            this.mProtocol = protocol;
            this.mIntegerFormat = integerFormat;
            this.mTextFormatter = textFormatter;
            this.mTooltip = tooltip;
        }

        public Protocol getProtocol() {
            return this.mProtocol;
        }

        public IntegerFormat getIntegerFormat() {
            return this.mIntegerFormat;
        }

        public TextFormatter<Integer> getTextFormatter() {
            return this.mTextFormatter;
        }

        public String getTooltip() {
            return this.mTooltip;
        }
    }
}

