/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.radio.Radio;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioIdEditor
extends IdentifierEditor<Radio> {
    private static final Logger mLog = LoggerFactory.getLogger(RadioIdEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private Label mFormatLabel;
    private TextField mRadioIdField;
    private TextFormatter<Integer> mIntegerTextFormatter;
    private List<RadioDetail> mRadioDetails = new ArrayList<RadioDetail>();
    private RadioValueChangeListener mRadioValueChangeListener = new RadioValueChangeListener();

    public RadioIdEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.loadRadioDetails();
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("Radio ID");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getRadioIdField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getRadioIdField());
        GridPane.setConstraints((Node)this.getFormatLabel(), (int)3, (int)0);
        gridPane.getChildren().add((Object)this.getFormatLabel());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(Radio item) {
        super.setItem(item);
        Radio radioId = (Radio)this.getItem();
        this.getProtocolLabel().setDisable(radioId == null);
        this.getRadioIdField().setDisable(radioId == null);
        if (radioId != null) {
            this.getProtocolLabel().setText(radioId.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getRadioIdField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mIntegerTextFormatter != null) {
            this.mIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mRadioValueChangeListener);
        }
        if ((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((Radio)this.getItem()).getProtocol())) != null) {
            RadioDetail radioDetail = this.getRadioDetail(((Radio)this.getItem()).getProtocol(), format);
            if (radioDetail != null) {
                this.mIntegerTextFormatter = radioDetail.getTextFormatter();
                Integer value = this.getItem() != null ? Integer.valueOf(((Radio)this.getItem()).getValue()) : null;
                this.mRadioIdField.setTextFormatter(this.mIntegerTextFormatter);
                this.mRadioIdField.setTooltip(new Tooltip(radioDetail.getTooltip()));
                this.mIntegerTextFormatter.setValue((Object)value);
                this.mIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mRadioValueChangeListener);
            } else {
                mLog.warn("Couldn't find radio detail for protocol [" + String.valueOf((Object)((Radio)this.getItem()).getProtocol()) + "] and format [" + String.valueOf((Object)format) + "]");
            }
            this.getFormatLabel().setText(radioDetail.getTooltip());
        } else {
            this.getFormatLabel().setText(" ");
            mLog.warn("Integer format combo box does not have a selected value.");
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getFormatLabel() {
        if (this.mFormatLabel == null) {
            this.mFormatLabel = new Label(" ");
        }
        return this.mFormatLabel;
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getRadioIdField() {
        if (this.mRadioIdField == null) {
            this.mRadioIdField = new TextField();
            this.mRadioIdField.setTextFormatter(this.mIntegerTextFormatter);
        }
        return this.mRadioIdField;
    }

    private RadioDetail getRadioDetail(Protocol protocol, IntegerFormat integerFormat) {
        for (RadioDetail detail : this.mRadioDetails) {
            if (detail.getProtocol() != protocol || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("Unable to find radio id editor for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "] - using default editor");
        for (RadioDetail detail : this.mRadioDetails) {
            if (detail.getProtocol() != Protocol.UNKNOWN || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("No Radio Detail is configured for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "]");
        return null;
    }

    private void loadRadioDetails() {
        this.mRadioDetails.clear();
        this.mRadioDetails.add(new RadioDetail(this, Protocol.APCO25, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - 16777215"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.APCO25, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.DMR, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - 16777215"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.DMR, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.PASSPORT, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0x7FFFFF), "Format: 0 - 8388607"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.PASSPORT, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0x7FFFFF), "Format: 0 - 7FFFFF"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.UNKNOWN, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.UNKNOWN, IntegerFormat.FORMATTED, new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        this.mRadioDetails.add(new RadioDetail(this, Protocol.UNKNOWN, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
    }

    public class RadioValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (RadioIdEditor.this.getItem() != null) {
                ((Radio)RadioIdEditor.this.getItem()).setValue(newValue != null ? newValue : 0);
                RadioIdEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class RadioDetail {
        private Protocol mProtocol;
        private IntegerFormat mIntegerFormat;
        private TextFormatter<Integer> mTextFormatter;
        private String mTooltip;

        public RadioDetail(RadioIdEditor this$0, Protocol protocol, IntegerFormat integerFormat, TextFormatter<Integer> textFormatter, String tooltip) {
            this.mProtocol = protocol;
            this.mIntegerFormat = integerFormat;
            this.mTextFormatter = textFormatter;
            this.mTooltip = tooltip;
        }

        public Protocol getProtocol() {
            return this.mProtocol;
        }

        public IntegerFormat getIntegerFormat() {
            return this.mIntegerFormat;
        }

        public TextFormatter<Integer> getTextFormatter() {
            return this.mTextFormatter;
        }

        public String getTooltip() {
            return this.mTooltip;
        }
    }
}

