/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.lojack.LoJackFunctionAndID;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.module.decode.lj1200.LJ1200Message;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LojackEditor
extends IdentifierEditor<LoJackFunctionAndID> {
    private static final Logger mLog = LoggerFactory.getLogger(LojackEditor.class);
    private ComboBox<LJ1200Message.Function> mFunctionComboBox;
    private TextField mIdentifierField;

    public LojackEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        Label typeLabel = new Label("LoJack Function");
        GridPane.setConstraints((Node)typeLabel, (int)0, (int)0);
        gridPane.getChildren().add((Object)typeLabel);
        GridPane.setConstraints(this.getFunctionComboBox(), (int)1, (int)0);
        gridPane.getChildren().add(this.getFunctionComboBox());
        GridPane.setConstraints((Node)this.getIdentifierField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getIdentifierField());
        Label helpLabel = new Label("Format: 5 numbers, characters or (*)wildcard - e.g. AB*12");
        GridPane.setConstraints((Node)helpLabel, (int)3, (int)0);
        gridPane.getChildren().add((Object)helpLabel);
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(LoJackFunctionAndID item) {
        super.setItem(item);
        this.getFunctionComboBox().setDisable(item == null);
        this.getIdentifierField().setDisable(item == null);
        if (item != null) {
            this.getFunctionComboBox().getSelectionModel().select((Object)item.getFunction());
            this.getIdentifierField().setText(item.getID());
        } else {
            this.getFunctionComboBox().getSelectionModel().select(null);
            this.getIdentifierField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private ComboBox<LJ1200Message.Function> getFunctionComboBox() {
        if (this.mFunctionComboBox == null) {
            this.mFunctionComboBox = new ComboBox();
            this.mFunctionComboBox.getItems().addAll((Object[])LJ1200Message.Function.values());
            this.mFunctionComboBox.setDisable(true);
            this.mFunctionComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                ((LoJackFunctionAndID)this.getItem()).setFunction((LJ1200Message.Function)((Object)newValue));
                this.modifiedProperty().set(true);
            });
        }
        return this.mFunctionComboBox;
    }

    private TextField getIdentifierField() {
        if (this.mIdentifierField == null) {
            this.mIdentifierField = new TextField();
            this.mIdentifierField.setDisable(true);
            this.mIdentifierField.textProperty().addListener((observable, oldValue, newValue) -> {
                ((LoJackFunctionAndID)this.getItem()).setID((String)newValue);
                this.modifiedProperty().set(true);
            });
            String text = "ID: 5 numbers or characters (e.g. 1BN47)\nWildcard: asterisk (*) for any character (e.g. AB*12)\nMiddle character in a reply ID code identifies the entity\nValid middle character entities are:\n Tower: X,Y\n Transponder: 0-9,A,C-H,J-N,P-W\n Not Used: B,I,O,Z";
            Tooltip toolTip = new Tooltip(text);
            toolTip.wrapTextProperty().set(true);
            this.mIdentifierField.setTooltip(toolTip);
        }
        return this.mIdentifierField;
    }
}

