/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.dcs.Dcs;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.module.decode.dcs.DCSCode;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcsEditor
extends IdentifierEditor<Dcs> {
    private static final Logger mLog = LoggerFactory.getLogger(DcsEditor.class);
    private ComboBox<DCSCode> mDCSCodeComboBox;

    public DcsEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        Label typeLabel = new Label("DCS Code");
        GridPane.setConstraints((Node)typeLabel, (int)0, (int)0);
        gridPane.getChildren().add((Object)typeLabel);
        GridPane.setConstraints(this.getDCSCodeComboBox(), (int)1, (int)0);
        gridPane.getChildren().add(this.getDCSCodeComboBox());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(Dcs item) {
        super.setItem(item);
        if (item.isValid()) {
            this.getDCSCodeComboBox().getSelectionModel().select((Object)item.getDCSCode());
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private ComboBox<DCSCode> getDCSCodeComboBox() {
        if (this.mDCSCodeComboBox == null) {
            this.mDCSCodeComboBox = new ComboBox();
            this.mDCSCodeComboBox.getItems().addAll(DCSCode.STANDARD_CODES);
            this.mDCSCodeComboBox.getItems().addAll(DCSCode.INVERTED_CODES);
            this.mDCSCodeComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
                ((Dcs)this.getItem()).setDCSCode((DCSCode)((Object)((Object)this.getDCSCodeComboBox().getSelectionModel().getSelectedItem())));
                this.modifiedProperty().set(true);
            });
        }
        return this.mDCSCodeComboBox;
    }
}

