/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.gui.playlist.alias.AliasConfigurationEditor;
import io.github.dsheirer.gui.playlist.alias.AliasTabRequest;
import io.github.dsheirer.gui.playlist.alias.AliasViewByIdentifierEditor;
import io.github.dsheirer.gui.playlist.alias.AliasViewByRecordingEditor;
import io.github.dsheirer.gui.playlist.alias.ViewAliasIdentifierRequest;
import io.github.dsheirer.gui.playlist.alias.ViewAliasRequest;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class AliasEditor
extends TabPane {
    private PlaylistManager mPlaylistManager;
    private UserPreferences mUserPreferences;
    private AliasConfigurationEditor mAliasConfigurationEditor;
    private AliasViewByIdentifierEditor mAliasViewByIdentifierEditor;
    private Tab mAliasConfigurationTab;
    private Tab mAliasIdentifierTab;
    private Tab mAliasRecordingTab;

    public AliasEditor(PlaylistManager playlistManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mUserPreferences = userPreferences;
        this.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab viewByTab = new Tab("View By:");
        viewByTab.setDisable(true);
        this.getTabs().addAll((Object[])new Tab[]{viewByTab, this.getAliasConfigurationTab(), this.getAliasIdentifierTab(), this.getAliasRecordingTab()});
    }

    public void process(AliasTabRequest aliasTabRequest) {
        AliasID aliasID;
        if (aliasTabRequest instanceof ViewAliasRequest) {
            Alias alias = ((ViewAliasRequest)aliasTabRequest).getAlias();
            if (alias != null) {
                this.getSelectionModel().select((Object)this.getAliasConfigurationTab());
                this.getAliasConfigurationEditor().show(alias);
            }
        } else if (aliasTabRequest instanceof ViewAliasIdentifierRequest && (aliasID = ((ViewAliasIdentifierRequest)aliasTabRequest).getAliasId()) != null) {
            this.getSelectionModel().select((Object)this.getAliasIdentifierTab());
            this.getAliasViewByIdentifierEditor().show(aliasID);
        }
    }

    private Tab getAliasConfigurationTab() {
        if (this.mAliasConfigurationTab == null) {
            this.mAliasConfigurationTab = new Tab("Alias");
            this.mAliasConfigurationTab.setContent((Node)this.getAliasConfigurationEditor());
        }
        return this.mAliasConfigurationTab;
    }

    private AliasConfigurationEditor getAliasConfigurationEditor() {
        if (this.mAliasConfigurationEditor == null) {
            this.mAliasConfigurationEditor = new AliasConfigurationEditor(this.mPlaylistManager, this.mUserPreferences);
        }
        return this.mAliasConfigurationEditor;
    }

    private Tab getAliasIdentifierTab() {
        if (this.mAliasIdentifierTab == null) {
            this.mAliasIdentifierTab = new Tab("Identifier");
            this.mAliasIdentifierTab.setContent((Node)this.getAliasViewByIdentifierEditor());
        }
        return this.mAliasIdentifierTab;
    }

    private AliasViewByIdentifierEditor getAliasViewByIdentifierEditor() {
        if (this.mAliasViewByIdentifierEditor == null) {
            this.mAliasViewByIdentifierEditor = new AliasViewByIdentifierEditor(this.mPlaylistManager, this.getAliasIdentifierTab().selectedProperty());
        }
        return this.mAliasViewByIdentifierEditor;
    }

    private Tab getAliasRecordingTab() {
        if (this.mAliasRecordingTab == null) {
            this.mAliasRecordingTab = new Tab("Record");
            this.mAliasRecordingTab.setContent((Node)new AliasViewByRecordingEditor(this.mPlaylistManager));
        }
        return this.mAliasRecordingTab;
    }
}

