/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.chart.ComplexSampleLineChart;
import io.github.dsheirer.gui.instrument.chart.DoubleLineChart;
import io.github.dsheirer.gui.instrument.chart.EyeDiagramChart;
import io.github.dsheirer.gui.instrument.chart.PhaseLineChart;
import io.github.dsheirer.gui.instrument.chart.SymbolChart;
import io.github.dsheirer.gui.instrument.decoder.ComplexDecoderPane;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DecoderC4FMInstrumented;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25Phase1C4FMPane
extends ComplexDecoderPane {
    private static final Logger mLog = LoggerFactory.getLogger(P25Phase1C4FMPane.class);
    private HBox mSampleChartBox;
    private ComplexSampleLineChart mSampleLineChart;
    private EyeDiagramChart mEyeDiagramChart;
    private HBox mDecoderChartBox;
    private SymbolChart mSymbolChart;
    private PhaseLineChart mPLLPhaseErrorLineChart;
    private DoubleLineChart mPLLFrequencyLineChart;
    private DoubleLineChart mSamplesPerSymbolLineChart;
    private Broadcaster<ComplexSamples> mFilteredBufferBroadcaster = new Broadcaster();
    private P25P1DecoderC4FMInstrumented mDecoder = new P25P1DecoderC4FMInstrumented();

    public P25Phase1C4FMPane() {
        super(DecoderType.P25_PHASE1);
        this.init();
    }

    private void init() {
        this.addListener(nativeBuffer -> {
            Iterator<ComplexSamples> iterator = nativeBuffer.iterator();
            while (iterator.hasNext()) {
                this.getDecoder().receive(iterator.next());
            }
        });
        this.getDecoder().setFilteredBufferListener(this.mFilteredBufferBroadcaster);
        this.getDecoder().setComplexSymbolListener(this.getSymbolChart());
        this.getDecoder().setPLLPhaseErrorListener(this.getPLLPhaseErrorLineChart());
        this.getDecoder().setPLLFrequencyListener(this.getPLLFrequencyLineChart());
        this.getDecoder().setSymbolDecisionDataListener(this.getEyeDiagramChart());
        this.getDecoder().setSamplesPerSymbolListener(this.getSamplesPerSymbolLineChart());
        this.mFilteredBufferBroadcaster.addListener(this.getSampleLineChart());
        HBox.setHgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getDecoderChartBox(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getSampleChartBox(), this.getDecoderChartBox()});
        this.mDecoder.setMessageListener(new Listener<IMessage>(this){

            @Override
            public void receive(IMessage message) {
                mLog.debug(message.toString());
            }
        });
    }

    @Override
    public void setSampleRate(double sampleRate) {
        mLog.debug("Configuring for sample rate: " + sampleRate);
        this.mDecoder.setSampleRate(sampleRate);
        double samplesPerSymbol = sampleRate / 4800.0;
        this.getSampleLineChart().setSamplesPerSymbol((int)samplesPerSymbol);
    }

    private P25P1DecoderC4FMInstrumented getDecoder() {
        return this.mDecoder;
    }

    private SymbolChart getSymbolChart() {
        if (this.mSymbolChart == null) {
            this.mSymbolChart = new SymbolChart(10);
        }
        return this.mSymbolChart;
    }

    private HBox getDecoderChartBox() {
        if (this.mDecoderChartBox == null) {
            this.mDecoderChartBox = new HBox();
            this.mDecoderChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSymbolChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLPhaseErrorLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLFrequencyLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSymbolChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLPhaseErrorLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLFrequencyLineChart(), (Priority)Priority.ALWAYS);
            this.mDecoderChartBox.getChildren().addAll((Object[])new Node[]{this.getSymbolChart(), this.getPLLPhaseErrorLineChart(), this.getPLLFrequencyLineChart()});
        }
        return this.mDecoderChartBox;
    }

    private HBox getSampleChartBox() {
        if (this.mSampleChartBox == null) {
            this.mSampleChartBox = new HBox();
            this.mSampleChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSampleLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getEyeDiagramChart().setMaxWidth(Double.MAX_VALUE);
            this.getSamplesPerSymbolLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getEyeDiagramChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getSamplesPerSymbolLineChart(), (Priority)Priority.ALWAYS);
            this.mSampleChartBox.getChildren().addAll((Object[])new Node[]{this.getSampleLineChart(), this.getEyeDiagramChart(), this.getSamplesPerSymbolLineChart()});
        }
        return this.mSampleChartBox;
    }

    private ComplexSampleLineChart getSampleLineChart() {
        if (this.mSampleLineChart == null) {
            this.mSampleLineChart = new ComplexSampleLineChart("Raw Samples", 100, 10);
        }
        return this.mSampleLineChart;
    }

    private EyeDiagramChart getEyeDiagramChart() {
        if (this.mEyeDiagramChart == null) {
            this.mEyeDiagramChart = new EyeDiagramChart(10, "Symbol: 3-4");
        }
        return this.mEyeDiagramChart;
    }

    private PhaseLineChart getPLLPhaseErrorLineChart() {
        if (this.mPLLPhaseErrorLineChart == null) {
            this.mPLLPhaseErrorLineChart = new PhaseLineChart(40);
        }
        return this.mPLLPhaseErrorLineChart;
    }

    private DoubleLineChart getPLLFrequencyLineChart() {
        if (this.mPLLFrequencyLineChart == null) {
            this.mPLLFrequencyLineChart = new DoubleLineChart("PLL Frequency", -500.0, 500.0, 50.0, 40);
        }
        return this.mPLLFrequencyLineChart;
    }

    private DoubleLineChart getSamplesPerSymbolLineChart() {
        if (this.mSamplesPerSymbolLineChart == null) {
            this.mSamplesPerSymbolLineChart = new DoubleLineChart("Sample Point", 9.5, 11.5, 0.1, 40);
        }
        return this.mSamplesPerSymbolLineChart;
    }
}

