/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.chart.LTRNetSampleBufferChart;
import io.github.dsheirer.gui.instrument.chart.RealSampleLineChart;
import io.github.dsheirer.gui.instrument.chart.ZeroCrossingErrorDetectorChart;
import io.github.dsheirer.gui.instrument.decoder.RealDecoderPane;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.ltrnet.DecodeConfigLTRNet;
import io.github.dsheirer.module.decode.ltrnet.LTRNetDecoderInstrumented;
import io.github.dsheirer.sample.Listener;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRNetPane
extends RealDecoderPane {
    private static final Logger mLog = LoggerFactory.getLogger(LTRNetPane.class);
    private HBox mSampleChartBox;
    private RealSampleLineChart mRealSampleLineChart;
    private HBox mSymbolDecoderBox;
    private LTRNetSampleBufferChart mLTRNetSampleBufferChart;
    private ZeroCrossingErrorDetectorChart mZeroCrossingErrorDetectorChart;
    private LTRNetDecoderInstrumented mDecoder;

    public LTRNetPane() {
        super(DecoderType.LTR_NET);
        this.init();
    }

    private void init() {
        this.addListener(this.getDecoder());
        this.addListener(this.getSampleLineChart());
        HBox.setHgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getSymbolDecoderBox(), (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.getSymbolDecoderBox(), (Priority)Priority.ALWAYS);
        this.getSampleChartBox().setMaxWidth(Double.MAX_VALUE);
        this.getSymbolDecoderBox().setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Object[])new Node[]{this.getSampleChartBox(), this.getSymbolDecoderBox()});
    }

    private LTRNetDecoderInstrumented getDecoder() {
        if (this.mDecoder == null) {
            DecodeConfigLTRNet config = new DecodeConfigLTRNet();
            config.setMessageDirection(MessageDirection.OSW);
            this.mDecoder = new LTRNetDecoderInstrumented(config);
            this.mDecoder.setMessageListener(new Listener<IMessage>(this){

                @Override
                public void receive(IMessage message) {
                    mLog.debug(message.toString());
                }
            });
        }
        return this.mDecoder;
    }

    private HBox getSampleChartBox() {
        if (this.mSampleChartBox == null) {
            this.mSampleChartBox = new HBox();
            this.mSampleChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSampleLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleLineChart(), (Priority)Priority.ALWAYS);
            this.mSampleChartBox.getChildren().addAll((Object[])new Node[]{this.getSampleLineChart()});
        }
        return this.mSampleChartBox;
    }

    private RealSampleLineChart getSampleLineChart() {
        if (this.mRealSampleLineChart == null) {
            this.mRealSampleLineChart = new RealSampleLineChart(500, 26.666666666666668);
        }
        return this.mRealSampleLineChart;
    }

    private HBox getSymbolDecoderBox() {
        if (this.mSymbolDecoderBox == null) {
            this.mSymbolDecoderBox = new HBox();
            this.mSymbolDecoderBox.setMaxWidth(Double.MAX_VALUE);
            this.getSampleBufferChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleBufferChart(), (Priority)Priority.ALWAYS);
            this.mSampleChartBox.getChildren().addAll((Object[])new Node[]{this.getSampleBufferChart(), this.getZeroCrossingErrorDetectorChart()});
        }
        return this.mSymbolDecoderBox;
    }

    private LTRNetSampleBufferChart getSampleBufferChart() {
        if (this.mLTRNetSampleBufferChart == null) {
            this.mLTRNetSampleBufferChart = new LTRNetSampleBufferChart(this.getDecoder(), 106);
        }
        return this.mLTRNetSampleBufferChart;
    }

    private ZeroCrossingErrorDetectorChart getZeroCrossingErrorDetectorChart() {
        if (this.mZeroCrossingErrorDetectorChart == null) {
            // empty if block
        }
        return this.mZeroCrossingErrorDetectorChart;
    }
}

