/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.decoder.AbstractDecoderPane;
import io.github.dsheirer.gui.instrument.decoder.ComplexDecoderPane;
import io.github.dsheirer.gui.instrument.decoder.DMRPane;
import io.github.dsheirer.gui.instrument.decoder.Fleetsync2Pane;
import io.github.dsheirer.gui.instrument.decoder.LJ1200Pane;
import io.github.dsheirer.gui.instrument.decoder.LTRNetPane;
import io.github.dsheirer.gui.instrument.decoder.MDC1200Pane;
import io.github.dsheirer.gui.instrument.decoder.MPT1327Pane;
import io.github.dsheirer.gui.instrument.decoder.P25Phase1C4FMPane;
import io.github.dsheirer.gui.instrument.decoder.P25Phase1LSMPane;
import io.github.dsheirer.gui.instrument.decoder.P25Phase2HDQPSKPane;
import io.github.dsheirer.gui.instrument.decoder.Tait1200Pane;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import java.util.EnumSet;

public class DecoderPaneFactory {
    private static final EnumSet<DecoderType> SUPPORTED_DECODER_TYPES = EnumSet.of(DecoderType.P25_PHASE1, new DecoderType[]{DecoderType.P25_PHASE2, DecoderType.FLEETSYNC2, DecoderType.LJ_1200, DecoderType.LTR_NET, DecoderType.MDC1200, DecoderType.MPT1327, DecoderType.TAIT_1200, DecoderType.DMR});

    public static AbstractDecoderPane getDecoderPane(DecoderType decoderType) {
        switch (decoderType) {
            case FLEETSYNC2: {
                return new Fleetsync2Pane();
            }
            case LJ_1200: {
                return new LJ1200Pane();
            }
            case LTR_NET: {
                return new LTRNetPane();
            }
            case MDC1200: {
                return new MDC1200Pane();
            }
            case MPT1327: {
                return new MPT1327Pane();
            }
            case TAIT_1200: {
                return new Tait1200Pane();
            }
            case P25_PHASE1: {
                throw new IllegalArgumentException("Use the getP25P1DecoderPane() method for P25 decoder type");
            }
            case P25_PHASE2: {
                return new P25Phase2HDQPSKPane();
            }
            case DMR: {
                return new DMRPane();
            }
        }
        return DecoderPaneFactory.getDefaultPane();
    }

    public static AbstractDecoderPane getP25P1DecoderPane(P25P1Decoder.Modulation modulation) {
        switch (modulation) {
            case C4FM: {
                return new P25Phase1C4FMPane();
            }
            case CQPSK: {
                return new P25Phase1LSMPane();
            }
        }
        return DecoderPaneFactory.getDefaultPane();
    }

    public static AbstractDecoderPane getDefaultPane() {
        return new ComplexDecoderPane();
    }

    public static boolean isSupported(DecoderType decoderType) {
        return SUPPORTED_DECODER_TYPES.contains((Object)decoderType);
    }
}

