/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.chart.AFSK1200SampleBufferChart;
import io.github.dsheirer.gui.instrument.chart.AFSK1200ZeroCrossingErrorDetectorChart;
import io.github.dsheirer.gui.instrument.chart.DecodedSymbolChart;
import io.github.dsheirer.gui.instrument.chart.IInstrumentedAFSK1200Decoder;
import io.github.dsheirer.gui.instrument.chart.RealSampleLineChart;
import io.github.dsheirer.gui.instrument.decoder.RealDecoderPane;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.sample.Listener;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAFSK1200Pane
extends RealDecoderPane {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractAFSK1200Pane.class);
    private HBox mSampleChartBox;
    private RealSampleLineChart mRealSampleLineChart;
    private HBox mSymbolDecoderBox;
    private AFSK1200SampleBufferChart mSampleBufferChart;
    private AFSK1200ZeroCrossingErrorDetectorChart mZeroCrossingErrorDetectorChart;
    private DecodedSymbolChart mDecodedSymbolChart;
    private IInstrumentedAFSK1200Decoder mDecoder;

    public AbstractAFSK1200Pane(DecoderType decoderType) {
        super(decoderType);
        this.init();
    }

    private void init() {
        this.addListener((Listener)((Object)this.getDecoder()));
        this.addListener(this.getSampleLineChart());
        HBox.setHgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getSymbolDecoderBox(), (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.getSymbolDecoderBox(), (Priority)Priority.ALWAYS);
        this.getSampleChartBox().setMaxWidth(Double.MAX_VALUE);
        this.getSymbolDecoderBox().setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Object[])new Node[]{this.getSampleChartBox(), this.getSymbolDecoderBox()});
        this.getDecoder().getAFSK1200Decoder().addListener(this.getDecodedSymbolChart());
        this.getDecoder().setMessageListener(new Listener<IMessage>(this){

            @Override
            public void receive(IMessage message) {
                mLog.debug((message.isValid() ? "PASS " : "FAIL ") + message.toString());
            }
        });
    }

    protected abstract IInstrumentedAFSK1200Decoder getDecoder();

    private HBox getSampleChartBox() {
        if (this.mSampleChartBox == null) {
            this.mSampleChartBox = new HBox();
            this.mSampleChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSampleLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getDecodedSymbolChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getDecodedSymbolChart(), (Priority)Priority.ALWAYS);
            this.mSampleChartBox.getChildren().addAll((Object[])new Node[]{this.getSampleLineChart(), this.getDecodedSymbolChart()});
        }
        return this.mSampleChartBox;
    }

    private RealSampleLineChart getSampleLineChart() {
        if (this.mRealSampleLineChart == null) {
            this.mRealSampleLineChart = new RealSampleLineChart(200, 10.0);
        }
        return this.mRealSampleLineChart;
    }

    private HBox getSymbolDecoderBox() {
        if (this.mSymbolDecoderBox == null) {
            this.mSymbolDecoderBox = new HBox();
            this.mSymbolDecoderBox.setMaxWidth(Double.MAX_VALUE);
            this.getSampleBufferChart().setMaxWidth(Double.MAX_VALUE);
            this.getZeroCrossingErrorDetectorChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleBufferChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getZeroCrossingErrorDetectorChart(), (Priority)Priority.ALWAYS);
            this.mSymbolDecoderBox.getChildren().addAll((Object[])new Node[]{this.getSampleBufferChart(), this.getZeroCrossingErrorDetectorChart()});
        }
        return this.mSymbolDecoderBox;
    }

    private AFSK1200SampleBufferChart getSampleBufferChart() {
        if (this.mSampleBufferChart == null) {
            this.mSampleBufferChart = new AFSK1200SampleBufferChart(this.getDecoder(), 106);
        }
        return this.mSampleBufferChart;
    }

    private AFSK1200ZeroCrossingErrorDetectorChart getZeroCrossingErrorDetectorChart() {
        if (this.mZeroCrossingErrorDetectorChart == null) {
            this.mZeroCrossingErrorDetectorChart = new AFSK1200ZeroCrossingErrorDetectorChart(this.getDecoder(), this.getDecoder().getAFSK1200Decoder().getErrorDetector().getBuffer().length);
        }
        return this.mZeroCrossingErrorDetectorChart;
    }

    private DecodedSymbolChart getDecodedSymbolChart() {
        if (this.mDecodedSymbolChart == null) {
            this.mDecodedSymbolChart = new DecodedSymbolChart(50);
        }
        return this.mDecodedSymbolChart;
    }
}

