/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.PolarChart;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYChartItem;
import eu.hansolo.fx.charts.series.XYSeries;
import io.github.dsheirer.buffer.ComplexCircularBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleXYChart
extends PolarChart<XYChartItem>
implements Listener<ComplexSamples> {
    private static ObservableList<XYChartItem> sChartItemList = FXCollections.observableArrayList();
    private static final Logger mLog;
    private ComplexCircularBuffer mCircularBuffer;
    private int mSampleCount;

    public SampleXYChart(int sampleCount, String title) {
        super(new XYPane(new XYSeries[]{new XYSeries(sChartItemList, ChartType.POLAR)}));
        this.mSampleCount = sampleCount;
        this.mCircularBuffer = new ComplexCircularBuffer(this.mSampleCount);
        this.getXYPane().setLowerBoundX(0.0);
        this.getXYPane().setUpperBoundX(1.0);
        this.getXYPane().setLowerBoundY(0.0);
        this.getXYPane().setUpperBoundY(1.0);
    }

    private void init() {
    }

    @Override
    public void receive(ComplexSamples buffer) {
        for (int x = 0; x < buffer.i().length; ++x) {
            this.mCircularBuffer.put(new Complex(buffer.i()[x], buffer.q()[x]));
        }
        Complex[] complexSamples = this.mCircularBuffer.getAll();
        XYSeries series = (XYSeries)this.getXYPane().getListOfSeries().get(0);
        series.setStroke((Paint)Color.BLUE);
        series.getItems().clear();
        for (Complex sample : complexSamples) {
            series.getItems().add((Object)new XYChartItem(sample.polarAngleDegrees(), (double)sample.magnitude(), Color.BLUE));
        }
        this.refresh();
    }

    static {
        sChartItemList.add((Object)new XYChartItem(1.0, 1.0));
        sChartItemList.add((Object)new XYChartItem(-1.0, -1.0));
        mLog = LoggerFactory.getLogger(SampleXYChart.class);
    }
}

