/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.buffer.FloatCircularBuffer;
import io.github.dsheirer.sample.Listener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealSampleLineChart
extends LineChart
implements Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(RealSampleLineChart.class);
    private ObservableList<XYChart.Data<Integer, Float>> mSamples = FXCollections.observableArrayList();
    private XYChart.Series<Integer, Float> mSampleSeries = new XYChart.Series("Samples", this.mSamples);
    private FloatCircularBuffer mRealCircularBuffer;

    public RealSampleLineChart(int length, double tickUnit) {
        super((Axis)new NumberAxis("Samples", 0.0, (double)length, tickUnit), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mSampleSeries});
        this.setData(observableList);
        this.init(length);
    }

    private void init(int length) {
        this.mRealCircularBuffer = new FloatCircularBuffer(length);
        for (int x = 0; x < length; ++x) {
            XYChart.Data sample = new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f));
            this.mSamples.add((Object)sample);
        }
        for (XYChart.Data data : this.mSampleSeries.getData()) {
            StackPane stackPane = (StackPane)data.getNode();
            stackPane.setVisible(false);
        }
    }

    @Override
    public void receive(float[] buffer) {
        for (float sample : buffer) {
            this.mRealCircularBuffer.put(sample);
        }
        float[] bufferSamples = this.mRealCircularBuffer.getAll();
        for (int x = 0; x < bufferSamples.length; ++x) {
            XYChart.Data sample = (XYChart.Data)this.mSamples.get(x);
            sample.setYValue((Object)Float.valueOf(bufferSamples[x]));
        }
    }
}

