/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.module.decode.ltrnet.LTRNetDecoderInstrumented;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRNetSampleBufferChart
extends LineChart {
    private static final Logger mLog = LoggerFactory.getLogger(LTRNetSampleBufferChart.class);
    private ObservableList<XYChart.Data<Integer, Float>> mSamples = FXCollections.observableArrayList();
    private XYChart.Series<Integer, Float> mSampleSeries = new XYChart.Series("Samples", this.mSamples);
    private ObservableList<XYChart.Data<Number, Number>> mSamplePoints = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSamplePointSeries = new XYChart.Series("Pointers", this.mSamplePoints);
    private ObservableList<XYChart.Data<Number, Number>> mSymbolSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSymbolSamplesSeries = new XYChart.Series("Next Symbol Samples", this.mSymbolSamples);
    private ObservableList<XYChart.Data<Number, Number>> mSymbol = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSymbolSeries = new XYChart.Series("Previous Symbol", this.mSymbol);
    private ObservableList<XYChart.Data<Number, Number>> mZeroCrossing = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mZeroCrossingSeries = new XYChart.Series("Zero Crossing", this.mZeroCrossing);
    private LTRNetDecoderInstrumented mLTRNetDecoderInstrumented;

    public LTRNetSampleBufferChart(LTRNetDecoderInstrumented decoder, int length) {
        super((Axis)new NumberAxis("Samples", 0.0, (double)length, 5.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mSampleSeries, this.mSamplePointSeries, this.mSymbolSamplesSeries, this.mSymbolSeries, this.mZeroCrossingSeries});
        this.setData(observableList);
        this.mLTRNetDecoderInstrumented = decoder;
        decoder.bufferCount.addListener((ChangeListener)new BufferChangeListener());
    }

    public void setBuffer(boolean[] buffer) {
        while (this.mSamples.size() < buffer.length) {
            XYChart.Data sample = new XYChart.Data((Object)this.mSamples.size(), (Object)Float.valueOf(0.0f));
            this.mSamples.add((Object)sample);
            for (XYChart.Data data : this.mSampleSeries.getData()) {
                StackPane stackPane = (StackPane)data.getNode();
                stackPane.setVisible(false);
            }
        }
        for (int x = 0; x < buffer.length; ++x) {
            XYChart.Data sample = (XYChart.Data)this.mSamples.get(x);
            sample.setYValue((Object)Float.valueOf(buffer[x] ? 0.5f : -0.5f));
        }
    }

    public class BufferChangeListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            XYChart.Data sample;
            while (LTRNetSampleBufferChart.this.mSymbol.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.55);
                LTRNetSampleBufferChart.this.mSymbol.add((Object)sample);
            }
            while (LTRNetSampleBufferChart.this.mZeroCrossing.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.65);
                LTRNetSampleBufferChart.this.mZeroCrossing.add((Object)sample);
            }
            while (LTRNetSampleBufferChart.this.mSamplePoints.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.75);
                LTRNetSampleBufferChart.this.mSamplePoints.add((Object)sample);
            }
            while (LTRNetSampleBufferChart.this.mSymbolSamples.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.85);
                LTRNetSampleBufferChart.this.mSymbolSamples.add((Object)sample);
            }
        }
    }

    public class ErrorChangeListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            while (LTRNetSampleBufferChart.this.mZeroCrossing.size() < 2) {
                XYChart.Data sample = new XYChart.Data((Object)0.0, (Object)-0.65);
                LTRNetSampleBufferChart.this.mZeroCrossing.add((Object)sample);
            }
        }
    }
}

