/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.buffer.DoubleCircularBuffer;
import io.github.dsheirer.sample.Listener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleLineChart
extends LineChart
implements Listener<Double> {
    private static final Logger mLog = LoggerFactory.getLogger(DoubleLineChart.class);
    private DoubleCircularBuffer mDoubleCircularBuffer;
    private ObservableList<XYChart.Data<Integer, Double>> mPhaseValues = FXCollections.observableArrayList();

    public DoubleLineChart(String seriesLabel, double min, double max, double tick, int length) {
        super((Axis)new NumberAxis(1.0, (double)length, 2.0), (Axis)new NumberAxis(min, max, tick));
        XYChart.Series phaseSeries = new XYChart.Series(seriesLabel, this.mPhaseValues);
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{phaseSeries});
        this.setData(observableList);
        this.init(length);
    }

    public void setMin(double min) {
        ((ValueAxis)this.getYAxis()).setLowerBound(min);
    }

    public void setMax(double max) {
        ((ValueAxis)this.getYAxis()).setUpperBound(max);
    }

    private void init(int length) {
        this.mDoubleCircularBuffer = new DoubleCircularBuffer(length);
        for (int x = 1; x <= length; ++x) {
            this.mPhaseValues.add((Object)new XYChart.Data((Object)x, (Object)0.0));
        }
    }

    @Override
    public void receive(Double phase) {
        this.mDoubleCircularBuffer.put(phase);
        this.updateChart();
    }

    private void updateChart() {
        double[] values = this.mDoubleCircularBuffer.getAll();
        for (int x = 0; x < values.length; ++x) {
            ((XYChart.Data)this.mPhaseValues.get(x)).setYValue((Object)values[x]);
        }
    }
}

