/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.sample.Listener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodedSymbolChart
extends LineChart
implements Listener<Boolean> {
    private static final Logger mLog = LoggerFactory.getLogger(DecodedSymbolChart.class);
    private ObservableList<XYChart.Data<Number, Number>> mSymbols = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSymbolSeries = new XYChart.Series("Samples", this.mSymbols);
    private boolean[] mSymbolBuffer;
    private int mSymbolBufferPointer;

    public DecodedSymbolChart(int length) {
        super((Axis)new NumberAxis("Symbols", 0.0, (double)length, 5.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mSymbolSeries});
        this.setData(observableList);
        for (int x = 0; x < length; ++x) {
            XYChart.Data symbol = new XYChart.Data((Object)x, (Object)Float.valueOf(-0.5f));
            this.mSymbols.add((Object)symbol);
        }
        this.mSymbolBuffer = new boolean[length];
    }

    @Override
    public void receive(Boolean symbol) {
        this.mSymbolBuffer[this.mSymbolBufferPointer++] = symbol;
        this.mSymbolBufferPointer %= this.mSymbolBuffer.length;
        this.update();
    }

    private void update() {
        for (int x = 0; x < this.mSymbolBuffer.length; ++x) {
            XYChart.Data symbol = (XYChart.Data)this.mSymbols.get(x);
            int offset = x + this.mSymbolBufferPointer;
            symbol.setYValue((Object)Float.valueOf(this.mSymbolBuffer[offset %= this.mSymbolBuffer.length] ? 0.5f : -0.5f));
        }
    }
}

