/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.buffer.ComplexCircularBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSampleListener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexSampleLineChart
extends LineChart
implements Listener<ComplexSamples>,
ComplexSampleListener {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexSampleLineChart.class);
    private ComplexCircularBuffer mComplexCircularBuffer;
    private ComplexCircularBuffer mDemodulationCircularBuffer;
    private ObservableList<XYChart.Data<Integer, Float>> mISamples = FXCollections.observableArrayList();
    private ObservableList<XYChart.Data<Integer, Float>> mQSamples = FXCollections.observableArrayList();
    private IntegerProperty mLengthProperty = new SimpleIntegerProperty(40);

    public ComplexSampleLineChart(String label, int length, int samplesPerSymbol) {
        super((Axis)new NumberAxis(label, 0.0, (double)length, 10.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        XYChart.Series iSampleSeries = new XYChart.Series("Inphase", this.mISamples);
        XYChart.Series qSampleSeries = new XYChart.Series("Quadrature", this.mQSamples);
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{iSampleSeries, qSampleSeries});
        this.setData(observableList);
        this.init(length, samplesPerSymbol);
    }

    public void setSamplesPerSymbol(int samplesPerSymbol) {
        this.mDemodulationCircularBuffer = new ComplexCircularBuffer(samplesPerSymbol);
    }

    private void init(int length, int samplesPerSymbol) {
        this.mLengthProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ComplexSampleLineChart.this.mComplexCircularBuffer = new ComplexCircularBuffer(newValue.intValue());
            }
        });
        this.mComplexCircularBuffer = new ComplexCircularBuffer(length);
        this.mDemodulationCircularBuffer = new ComplexCircularBuffer(samplesPerSymbol);
        this.length().setValue((Number)length);
        for (int x = 1; x <= length; ++x) {
            this.mISamples.add((Object)new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f)));
            this.mQSamples.add((Object)new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f)));
        }
    }

    public IntegerProperty length() {
        return this.mLengthProperty;
    }

    @Override
    public void receive(ComplexSamples samples) {
        for (int x = 0; x < samples.i().length; ++x) {
            this.receive(samples.i()[x], samples.q()[x]);
        }
    }

    @Override
    public void receive(float i, float q) {
        Complex sample = new Complex(i, q);
        sample.normalize();
        Complex previous = this.mDemodulationCircularBuffer.get(sample.copy());
        sample.multiply(previous.conjugate());
        this.mComplexCircularBuffer.put(sample);
        this.updateChart();
    }

    private void updateChart() {
        Complex[] samples = this.mComplexCircularBuffer.getAll();
        for (int x = 0; x < samples.length; ++x) {
            Complex sample = samples[x];
            if (sample == null) continue;
            sample.normalize();
            ((XYChart.Data)this.mISamples.get(x)).setYValue((Object)Float.valueOf(sample.inphase()));
            ((XYChart.Data)this.mQSamples.get(x)).setYValue((Object)Float.valueOf(sample.quadrature()));
        }
    }
}

