/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.gui.instrument.chart.IInstrumentedAFSK1200Decoder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFSK1200ZeroCrossingErrorDetectorChart
extends LineChart {
    private static final Logger mLog = LoggerFactory.getLogger(AFSK1200ZeroCrossingErrorDetectorChart.class);
    private ObservableList<XYChart.Data<Number, Number>> mCurrentSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mCurrentSampleSeries = new XYChart.Series("Samples", this.mCurrentSamples);
    private ObservableList<XYChart.Data<Number, Number>> mPreviousSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mPreviousSampleSeries = new XYChart.Series("Samples", this.mPreviousSamples);
    private ObservableList<XYChart.Data<Number, Number>> mDetected = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mDetectedSeries = new XYChart.Series("Detected", this.mDetected);
    private IInstrumentedAFSK1200Decoder mIInstrumentedAFSK1200Decoder;

    public AFSK1200ZeroCrossingErrorDetectorChart(IInstrumentedAFSK1200Decoder decoder, int length) {
        super((Axis)new NumberAxis("Samples", 0.0, (double)length, 5.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mCurrentSampleSeries, this.mPreviousSampleSeries, this.mDetectedSeries});
        this.setData(observableList);
        this.mIInstrumentedAFSK1200Decoder = decoder;
        decoder.getAFSK1200Decoder().getErrorDetector().timingError.addListener((ChangeListener)new ErrorChangeListener());
        decoder.getBufferCountProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                AFSK1200ZeroCrossingErrorDetectorChart.this.updateBuffer();
            }
        });
        for (int x = 0; x < length; ++x) {
            XYChart.Data sample = new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f));
            this.mCurrentSamples.add((Object)sample);
            XYChart.Data sample2 = new XYChart.Data((Object)x, (Object)Float.valueOf(0.0f));
            this.mPreviousSamples.add((Object)sample2);
        }
        XYChart.Data detected1 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.25f));
        this.mDetected.add((Object)detected1);
        XYChart.Data detected2 = new XYChart.Data((Object)5, (Object)Float.valueOf(-0.75f));
        this.mDetected.add((Object)detected2);
    }

    private void updateBuffer() {
        boolean[] samples = this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getErrorDetector().getBuffer();
        for (int x = 0; x < samples.length; ++x) {
            XYChart.Data sample = (XYChart.Data)this.mCurrentSamples.get(x);
            sample.setYValue((Object)Float.valueOf(samples[x] ? 0.7f : 0.3f));
        }
    }

    public class ErrorChangeListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            float error = AFSK1200ZeroCrossingErrorDetectorChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getErrorDetector().getError();
            boolean[] samples = AFSK1200ZeroCrossingErrorDetectorChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getErrorDetector().getBuffer();
            for (int x = 0; x < samples.length; ++x) {
                XYChart.Data sample = (XYChart.Data)AFSK1200ZeroCrossingErrorDetectorChart.this.mPreviousSamples.get(x);
                sample.setYValue((Object)Float.valueOf(samples[x] ? -0.4f : -0.6f));
            }
            if (error == 0.0f) {
                XYChart.Data detected1 = (XYChart.Data)AFSK1200ZeroCrossingErrorDetectorChart.this.mDetected.get(0);
                detected1.setXValue((Object)Float.valueOf(0.0f));
                detected2 = (XYChart.Data)AFSK1200ZeroCrossingErrorDetectorChart.this.mDetected.get(1);
                detected2.setXValue((Object)Float.valueOf(0.0f));
            } else {
                XYChart.Data detected1 = (XYChart.Data)AFSK1200ZeroCrossingErrorDetectorChart.this.mDetected.get(0);
                detected1.setXValue((Object)AFSK1200ZeroCrossingErrorDetectorChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getErrorDetector().getDetectedZeroCrossing());
                detected2 = (XYChart.Data)AFSK1200ZeroCrossingErrorDetectorChart.this.mDetected.get(1);
                detected2.setXValue((Object)AFSK1200ZeroCrossingErrorDetectorChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getErrorDetector().getDetectedZeroCrossing());
            }
        }
    }
}

