/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.gui.instrument.chart.IInstrumentedAFSK1200Decoder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFSK1200SampleBufferChart
extends LineChart {
    private static final Logger mLog = LoggerFactory.getLogger(AFSK1200SampleBufferChart.class);
    private ObservableList<XYChart.Data<Integer, Float>> mSamples = FXCollections.observableArrayList();
    private XYChart.Series<Integer, Float> mSampleSeries = new XYChart.Series("Samples", this.mSamples);
    private ObservableList<XYChart.Data<Number, Number>> mSamplePoints = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSamplePointSeries = new XYChart.Series("Pointers", this.mSamplePoints);
    private ObservableList<XYChart.Data<Number, Number>> mSymbolSamples = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mSymbolSamplesSeries = new XYChart.Series("Next Symbol Samples", this.mSymbolSamples);
    private ObservableList<XYChart.Data<Number, Number>> mPreviousSymbol = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mPreviousSymbolSeries = new XYChart.Series("Previous Symbol", this.mPreviousSymbol);
    private ObservableList<XYChart.Data<Number, Number>> mZeroCrossing = FXCollections.observableArrayList();
    private XYChart.Series<Number, Number> mZeroCrossingSeries = new XYChart.Series("Zero Crossing", this.mZeroCrossing);
    private IInstrumentedAFSK1200Decoder mIInstrumentedAFSK1200Decoder;

    public AFSK1200SampleBufferChart(IInstrumentedAFSK1200Decoder decoder, int length) {
        super((Axis)new NumberAxis("Samples", 0.0, (double)length, 5.0), (Axis)new NumberAxis("Value", -1.0, 1.0, 0.25));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new XYChart.Series[]{this.mSampleSeries, this.mSamplePointSeries, this.mSymbolSamplesSeries, this.mPreviousSymbolSeries, this.mZeroCrossingSeries});
        this.setData(observableList);
        this.mIInstrumentedAFSK1200Decoder = decoder;
        decoder.getBufferCountProperty().addListener((ChangeListener)new BufferChangeListener());
        decoder.getAFSK1200Decoder().getErrorDetector().timingError.addListener((ChangeListener)new ErrorChangeListener());
    }

    public void setBuffer(boolean[] buffer) {
        while (this.mSamples.size() < buffer.length) {
            XYChart.Data sample = new XYChart.Data((Object)this.mSamples.size(), (Object)Float.valueOf(0.0f));
            this.mSamples.add((Object)sample);
            for (XYChart.Data data : this.mSampleSeries.getData()) {
                StackPane stackPane = (StackPane)data.getNode();
                stackPane.setVisible(false);
            }
        }
        for (int x = 0; x < buffer.length; ++x) {
            XYChart.Data sample = (XYChart.Data)this.mSamples.get(x);
            sample.setYValue((Object)Float.valueOf(buffer[x] ? 0.5f : -0.5f));
        }
    }

    public class BufferChangeListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            XYChart.Data sample;
            AFSK1200SampleBufferChart.this.setBuffer(AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getDelayLine());
            while (AFSK1200SampleBufferChart.this.mPreviousSymbol.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.55);
                AFSK1200SampleBufferChart.this.mPreviousSymbol.add((Object)sample);
            }
            while (AFSK1200SampleBufferChart.this.mZeroCrossing.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.65);
                AFSK1200SampleBufferChart.this.mZeroCrossing.add((Object)sample);
            }
            while (AFSK1200SampleBufferChart.this.mSamplePoints.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.75);
                AFSK1200SampleBufferChart.this.mSamplePoints.add((Object)sample);
            }
            while (AFSK1200SampleBufferChart.this.mSymbolSamples.size() < 2) {
                sample = new XYChart.Data((Object)0.0, (Object)-0.85);
                AFSK1200SampleBufferChart.this.mSymbolSamples.add((Object)sample);
            }
            int pointer1 = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getDelayLinePointer();
            int pointer2 = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getDelayLineSecondPointer();
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mSamplePoints.get(0)).setXValue((Object)pointer1);
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mSamplePoints.get(1)).setXValue((Object)pointer2);
            float samplesPerSymbol = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getSamplesPerSymbol();
            boolean symbol = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getLastSymbol();
            int symbolStart = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getSymbolStart();
            int symbolEnd = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getSymbolEnd();
            float start = (float)pointer1 + samplesPerSymbol - 1.0f;
            float end = symbolEnd;
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mSymbolSamples.get(0)).setXValue((Object)Float.valueOf(start));
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mSymbolSamples.get(1)).setXValue((Object)Float.valueOf(end));
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mPreviousSymbol.get(0)).setXValue((Object)symbolStart);
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mPreviousSymbol.get(0)).setYValue((Object)Float.valueOf(symbol ? 0.55f : -0.55f));
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mPreviousSymbol.get(1)).setXValue((Object)symbolEnd);
            ((XYChart.Data)AFSK1200SampleBufferChart.this.mPreviousSymbol.get(1)).setYValue((Object)Float.valueOf(symbol ? 0.55f : -0.55f));
        }
    }

    public class ErrorChangeListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            while (AFSK1200SampleBufferChart.this.mZeroCrossing.size() < 2) {
                XYChart.Data sample = new XYChart.Data((Object)0.0, (Object)-0.65);
                AFSK1200SampleBufferChart.this.mZeroCrossing.add((Object)sample);
            }
            int pointer1 = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getDelayLinePointer();
            int pointer2 = AFSK1200SampleBufferChart.this.mIInstrumentedAFSK1200Decoder.getAFSK1200Decoder().getSampleBuffer().getDelayLineSecondPointer();
            int detectedZeroCrossing = ((Number)newValue).intValue();
        }
    }
}

