/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument;

import io.github.dsheirer.gui.instrument.RecentFilesMenu;
import io.github.dsheirer.gui.instrument.ViewerDesktop;
import io.github.dsheirer.gui.instrument.decoder.DecoderPaneFactory;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import java.io.File;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemodulatorViewerFX
extends Application {
    private static final Logger mLog = LoggerFactory.getLogger(DemodulatorViewerFX.class);
    private static final String PREFERENCE_FILE_OPEN_DEFAULT_FOLDER = "default.folder";
    private Preferences mPreferences = Preferences.userNodeForPackage(DemodulatorViewerFX.class);
    private Stage mStage;
    private MenuBar mMenuBar;
    private RecentFilesMenu mRecentFilesMenu;
    private ViewerDesktop mViewerDesktop;

    public void start(Stage primaryStage) throws Exception {
        this.mStage = primaryStage;
        this.setTitle();
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)this.getMenuBar());
        borderPane.setCenter((Node)this.getViewerDesktop());
        Scene scene = new Scene((Parent)borderPane, 1800.0, 900.0);
        this.mStage.setScene(scene);
        this.mStage.show();
    }

    private void setTitle() {
        this.mStage.setTitle("Demodulator Viewer FX");
    }

    private void setTitle(DecoderType decoderType) {
        if (decoderType != null) {
            this.mStage.setTitle("Demodulator Viewer FX - " + decoderType.getDisplayString());
        } else {
            this.setTitle();
        }
    }

    private void setTitle(P25P1Decoder.Modulation modulation) {
        if (modulation != null) {
            this.mStage.setTitle("Demodulator Viewer FX - P25 " + modulation.getLabel());
        } else {
            this.setTitle();
        }
    }

    private ViewerDesktop getViewerDesktop() {
        if (this.mViewerDesktop == null) {
            this.mViewerDesktop = new ViewerDesktop();
        }
        return this.mViewerDesktop;
    }

    private MenuBar getMenuBar() {
        if (this.mMenuBar == null) {
            this.mMenuBar = new MenuBar();
            Menu fileMenu = new Menu("File");
            MenuItem openMenuItem = new MenuItem("Open ...");
            openMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    File file;
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle("Open an I/Q recording file");
                    String directory = DemodulatorViewerFX.this.mPreferences.get(DemodulatorViewerFX.PREFERENCE_FILE_OPEN_DEFAULT_FOLDER, null);
                    if (directory != null) {
                        fileChooser.setInitialDirectory(new File(directory));
                    }
                    if ((file = fileChooser.showOpenDialog((Window)DemodulatorViewerFX.this.mStage)) != null) {
                        DemodulatorViewerFX.this.getViewerDesktop().load(file);
                        DemodulatorViewerFX.this.getRecentFilesMenu().add(file);
                        DemodulatorViewerFX.this.mPreferences.put(DemodulatorViewerFX.PREFERENCE_FILE_OPEN_DEFAULT_FOLDER, file.getParent());
                    }
                }
            });
            MenuItem closeMenuItem = new MenuItem("Close");
            closeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DemodulatorViewerFX.this.getViewerDesktop().close();
                }
            });
            MenuItem exitMenuItem = new MenuItem("Exit");
            exitMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

                public void handle(ActionEvent event) {
                    Platform.exit();
                }
            });
            fileMenu.getItems().addAll((Object[])new MenuItem[]{openMenuItem, this.getRecentFilesMenu(), closeMenuItem, new SeparatorMenuItem(), exitMenuItem});
            this.mMenuBar.getMenus().add((Object)fileMenu);
            Menu decoderMenu = new Menu("Decoder");
            for (final DecoderType decoderType : DecoderType.values()) {
                if (!DecoderPaneFactory.isSupported(decoderType)) continue;
                if (decoderType == DecoderType.P25_PHASE1) {
                    MenuItem c4fmDecoderMenuItem = new MenuItem("P25 Phase 1 C4FM");
                    c4fmDecoderMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent event) {
                            DemodulatorViewerFX.this.getViewerDesktop().setP25Phase1Decoder(P25P1Decoder.Modulation.C4FM);
                            DemodulatorViewerFX.this.setTitle(decoderType);
                        }
                    });
                    decoderMenu.getItems().add((Object)c4fmDecoderMenuItem);
                    MenuItem lsmDecoderMenuItem = new MenuItem("P25 Phase 1 LSM");
                    lsmDecoderMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent event) {
                            DemodulatorViewerFX.this.getViewerDesktop().setP25Phase1Decoder(P25P1Decoder.Modulation.CQPSK);
                            DemodulatorViewerFX.this.setTitle(decoderType);
                        }
                    });
                    decoderMenu.getItems().add((Object)lsmDecoderMenuItem);
                    continue;
                }
                MenuItem decoderMenuItem = new MenuItem(decoderType.getDisplayString());
                decoderMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        DemodulatorViewerFX.this.getViewerDesktop().setDecoder(decoderType);
                        DemodulatorViewerFX.this.setTitle(decoderType);
                    }
                });
                decoderMenu.getItems().add((Object)decoderMenuItem);
            }
            this.mMenuBar.getMenus().add((Object)decoderMenu);
        }
        return this.mMenuBar;
    }

    private RecentFilesMenu getRecentFilesMenu() {
        if (this.mRecentFilesMenu == null) {
            this.mRecentFilesMenu = new RecentFilesMenu("Recent", "demodulator.viewer", 5);
            this.mRecentFilesMenu.setFileSelectionListener(new RecentFilesMenu.IFileSelectionListener(){

                @Override
                public void fileSelected(File file) {
                    DemodulatorViewerFX.this.getViewerDesktop().load(file);
                }
            });
        }
        return this.mRecentFilesMenu;
    }

    public static void main(String[] args) {
        DemodulatorViewerFX.launch((String[])args);
    }
}

