/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.editor;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class Editor<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected T mItem;
    protected boolean mModified = false;
    protected Editor<?> mSaveRequestListener;

    protected void saveRequest() {
        if (this.mSaveRequestListener != null) {
            this.mSaveRequestListener.saveRequest();
        } else {
            this.save();
        }
    }

    public void setSaveRequestListener(Editor<?> listener) {
        this.mSaveRequestListener = listener;
    }

    public void setItem(T item) {
        if (this.isModified()) {
            int option = JOptionPane.showConfirmDialog(this, "This item has changed.  Do you want to save these changes?", "Save Changes?", 0, 3);
            if (option == 0) {
                this.saveRequest();
            }
            this.setModified(false);
        }
        this.mItem = item;
    }

    public T getItem() {
        return this.mItem;
    }

    public boolean hasItem() {
        return this.mItem != null;
    }

    public void setModified(boolean modified) {
        this.mModified = modified;
    }

    public boolean isModified() {
        return this.mModified;
    }

    public abstract void save();

    public void reset() {
        this.mModified = false;
        this.setItem(this.mItem);
    }
}

