/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class DbPowerMeter
extends JComponent {
    public static final double DEFAULT_MINIMUM_POWER = -110.0;
    public static final double DEFAULT_MAXIMUM_POWER = 0.0;
    private static final int BAR_WIDTH = 30;
    private static final int PADDING = 3;
    private static final int DOUBLE_PADDING = 6;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private static final Color COLOR_BAR = Color.LIGHT_GRAY;
    private static final Color COLOR_THRESHOLD = Color.BLUE;
    private static final Color COLOR_PEAK = Color.PINK;
    private double mMinimumValue = -110.0;
    private double mMaximumValue = 0.0;
    private double mExtent = this.mMaximumValue - this.mMinimumValue;
    private double mPeak = this.mMinimumValue;
    private double mPower = this.mMinimumValue;
    private double mSquelchThreshold = this.mMinimumValue;
    private boolean mPeakVisible = false;
    private boolean mSquelchThresholdVisible = false;

    public DbPowerMeter() {
        this.setPreferredSize(new Dimension(80, 100));
        this.setBorder(BorderFactory.createTitledBorder("Power (dB)"));
    }

    public void reset() {
        this.mPeak = this.mMinimumValue;
        this.mPower = this.mMinimumValue;
        this.mSquelchThreshold = this.mMinimumValue;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getForeground());
        g.drawRect(this.getInsets().left, this.getInsets().top, 30, this.getHeight() - this.getInsets().top - this.getInsets().bottom);
        g.setColor(COLOR_BAR);
        int fillHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 6;
        int height = (int)((double)fillHeight * this.getPowerPercent() - 3.0);
        int top = fillHeight - height + this.getInsets().top + 3;
        g.fillRect(this.getInsets().left + 3, top, 24, height);
        if (this.isSquelchThresholdVisible()) {
            g.setColor(COLOR_THRESHOLD);
            this.drawPercentLine(g, this.getSquelchThresholdPercent());
        }
        if (this.isPeakVisible()) {
            g.setColor(COLOR_PEAK);
            this.drawPercentLine(g, this.getPeakPercent());
        }
        g.setColor(this.getForeground());
        for (double legendValue : this.getScaleValues()) {
            this.drawScaleText(g, legendValue);
        }
    }

    private void drawPercentLine(Graphics g, double percentValue) {
        int totalHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 6;
        int height = (int)((double)totalHeight * percentValue - 3.0);
        int top = totalHeight - height + this.getInsets().top + 3;
        int left = this.getInsets().left;
        g.drawLine(left, top, left + 30, top);
    }

    private void drawScaleText(Graphics g, double value) {
        double percent = this.getPercent(value);
        int totalHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom - 6;
        int height = (int)((double)totalHeight * percent - 3.0);
        int top = totalHeight - height + this.getInsets().top + 3;
        int left = this.getInsets().left + 30 - 3;
        int textOffset = this.getFontMetrics(this.getFont()).getMaxAscent() / 2 - 2;
        String label = DECIMAL_FORMAT.format(value);
        g.drawString(label, left + 6, top + textOffset);
    }

    private List<Double> getScaleValues() {
        double ascent = this.getFontMetrics(this.getFont()).getMaxAscent() * 2;
        double labelCount = (double)this.getHeight() / ascent;
        double interval = this.getExtent() / labelCount;
        ArrayList<Double> values = new ArrayList<Double>();
        for (double x = 0.0; x > this.getMinimumValue(); x -= interval) {
            values.add(x);
        }
        return values;
    }

    public double getPower() {
        return this.mPower;
    }

    public void setPower(double power) {
        this.mPower = power > this.getMaximumValue() ? this.getMaximumValue() : (power < this.getMinimumValue() ? this.getMinimumValue() : power);
        this.repaint();
    }

    public double getSquelchThreshold() {
        return this.mSquelchThreshold;
    }

    public void setSquelchThreshold(double squelchThreshold) {
        this.mSquelchThreshold = squelchThreshold;
        this.repaint();
    }

    public double getMinimumValue() {
        return this.mMinimumValue;
    }

    public void setMinimumValue(double minimumValue) {
        this.mMinimumValue = minimumValue;
        this.updateExtent();
        this.repaint();
    }

    public double getMaximumValue() {
        return this.mMaximumValue;
    }

    public void setMaximumValue(double maximumValue) {
        this.mMaximumValue = maximumValue;
        this.updateExtent();
        this.repaint();
    }

    private void updateExtent() {
        this.mExtent = this.getMaximumValue() - this.getMinimumValue();
    }

    private double getExtent() {
        return this.mExtent;
    }

    public double getPeak() {
        return this.mPeak;
    }

    public void setPeak(double peak) {
        this.mPeak = peak;
        this.repaint();
    }

    public boolean isPeakVisible() {
        return this.mPeakVisible & this.isValidValue(this.getPeak());
    }

    public void setPeakVisible(boolean peakVisible) {
        this.mPeakVisible = peakVisible;
        this.repaint();
    }

    public boolean isSquelchThresholdVisible() {
        return this.mSquelchThresholdVisible & this.isValidValue(this.getSquelchThreshold());
    }

    public void setSquelchThresholdVisible(boolean squelchThresholdVisible) {
        this.mSquelchThresholdVisible = squelchThresholdVisible;
        this.repaint();
    }

    private double getPercent(double value) {
        return (value - this.getMinimumValue()) / this.getExtent();
    }

    private double getPowerPercent() {
        return this.getPercent(this.mPower);
    }

    private double getSquelchThresholdPercent() {
        return this.getPercent(this.mSquelchThreshold);
    }

    private double getPeakPercent() {
        return this.getPercent(this.mPeak);
    }

    private boolean isValidValue(double value) {
        return this.getMinimumValue() <= value && value <= this.getMaximumValue();
    }
}

