/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import io.github.dsheirer.buffer.CircularBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math3.util.FastMath;

public class ConstellationViewer
extends JPanel
implements Listener<Complex> {
    private static final long serialVersionUID = 1L;
    private int mSampleRate;
    private int mSymbolRate;
    private float mSamplesPerSymbol;
    private float mCounter = 0.0f;
    private float mOffset = 0.0f;
    private CircularBuffer<Complex> mBuffer = new CircularBuffer(5000);
    private Complex mPrevious = new Complex(1.0f, 1.0f);

    public ConstellationViewer(int sampleRate, int symbolRate) {
        this.mSampleRate = sampleRate;
        this.mSymbolRate = symbolRate;
        this.mSamplesPerSymbol = (float)this.mSampleRate / (float)this.mSymbolRate;
        this.initGui();
    }

    private void initGui() {
        this.setPreferredSize(new Dimension(200, 200));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new TimingOffsetItem((int)(ConstellationViewer.this.mSamplesPerSymbol * 10.0f), (int)(ConstellationViewer.this.mOffset * 10.0f)));
                    menu.show(ConstellationViewer.this, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
    }

    @Override
    public void receive(Complex sample) {
        this.mBuffer.receive(sample);
        Complex angle = Complex.multiply(sample, this.mPrevious.conjugate());
        this.repaint();
    }

    public void setOffset(float offset) {
        this.mOffset = offset;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(Color.BLUE);
        List<Complex> samples = this.mBuffer.getElements();
        double centerX = (double)this.getHeight() / 2.0;
        double centerY = (double)this.getWidth() / 2.0;
        double scale = 0.5;
        this.mCounter = 0.0f;
        for (Complex sample : samples) {
            if (this.mCounter > this.mOffset + this.mSamplesPerSymbol) {
                double i = sample.inphase() * this.mPrevious.inphase() - sample.quadrature() * -this.mPrevious.quadrature();
                double q = sample.quadrature() * this.mPrevious.inphase() + sample.inphase() * -this.mPrevious.quadrature();
                if (i == 0.0) {
                    angle = 0.0;
                } else {
                    double denominator = 1.0 / i;
                    angle = FastMath.atan((double)(q * denominator));
                }
                Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - i * scale, centerY - q * scale, 4.0, 4.0);
                graphics.draw(ellipse);
                this.mCounter -= this.mSamplesPerSymbol;
            }
            this.mCounter += 1.0f;
        }
    }

    public class TimingOffsetItem
    extends JSlider
    implements ChangeListener {
        private static final long serialVersionUID = 1L;

        public TimingOffsetItem(int maxValue, int currentValue) {
            super(0, 0, maxValue, currentValue);
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(5);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int value = ((JSlider)event.getSource()).getValue();
            ConstellationViewer.this.setOffset((float)value / 10.0f);
        }
    }
}

