/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.channelizer;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.channelizer.TwoChannelSynthesizerM2;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.oscillator.FS4DownConverter;
import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.spectrum.ComplexDftProcessor;
import io.github.dsheirer.spectrum.DFTSize;
import io.github.dsheirer.spectrum.SpectrumPanel;
import io.github.dsheirer.spectrum.converter.ComplexDecibelConverter;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynthesizerViewer
extends JFrame {
    private static final Logger mLog = LoggerFactory.getLogger(SynthesizerViewer.class);
    private static final int CHANNEL_BANDWIDTH = 12500;
    private static final int CHANNEL_SAMPLE_RATE = 25000;
    private static final int CHANNEL_FFT_FRAME_RATE = 20;
    private static final int DATA_GENERATOR_FRAME_RATE = 50;
    private SettingsManager mSettingsManager = new SettingsManager();
    private JPanel mPrimaryPanel;
    private PrimarySpectrumPanel mPrimarySpectrumPanel;
    private ChannelPanel mChannel1Panel;
    private ChannelPanel mChannel2Panel;
    private ChannelControlPanel mChannel1ControlPanel;
    private ChannelControlPanel mChannel2ControlPanel;
    private DFTSize mMainPanelDFTSize = DFTSize.FFT08192;
    private DFTSize mChannelPanelDFTSize = DFTSize.FFT08192;

    public SynthesizerViewer() {
        this.init();
    }

    public void start() {
        ThreadPool.SCHEDULED.scheduleAtFixedRate(new DataGenerationManager(), 0L, 20L, TimeUnit.MILLISECONDS);
    }

    private void init() {
        this.setTitle("Polyphase Synthesizer Viewer");
        this.setSize(500, 400);
        this.setDefaultCloseOperation(3);
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.setLocationRelativeTo(null);
        this.add(this.getPrimaryPanel());
    }

    private JPanel getPrimaryPanel() {
        if (this.mPrimaryPanel == null) {
            this.mPrimaryPanel = new JPanel();
            this.mPrimaryPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill][grow,fill]", "[grow,fill][grow,fill]"));
            this.mPrimaryPanel.add((Component)this.getSpectrumPanel(), "span");
            this.mPrimaryPanel.add(this.getChannel1Panel());
            this.mPrimaryPanel.add(this.getChannel2Panel());
        }
        return this.mPrimaryPanel;
    }

    private PrimarySpectrumPanel getSpectrumPanel() {
        if (this.mPrimarySpectrumPanel == null) {
            this.mPrimarySpectrumPanel = new PrimarySpectrumPanel(this.mSettingsManager);
            this.mPrimarySpectrumPanel.setPreferredSize(new Dimension(500, 200));
            this.mPrimarySpectrumPanel.setDFTSize(this.mMainPanelDFTSize);
        }
        return this.mPrimarySpectrumPanel;
    }

    private ChannelPanel getChannel1Panel() {
        if (this.mChannel1Panel == null) {
            this.mChannel1Panel = new ChannelPanel(this.mSettingsManager, this.getChannel1ControlPanel());
            this.mChannel1Panel.setPreferredSize(new Dimension(250, 200));
            this.mChannel1Panel.setDFTSize(this.mChannelPanelDFTSize);
        }
        return this.mChannel1Panel;
    }

    private ChannelPanel getChannel2Panel() {
        if (this.mChannel2Panel == null) {
            this.mChannel2Panel = new ChannelPanel(this.mSettingsManager, this.getChannel2ControlPanel());
            this.mChannel2Panel.setPreferredSize(new Dimension(250, 200));
            this.mChannel2Panel.setDFTSize(this.mChannelPanelDFTSize);
        }
        return this.mChannel2Panel;
    }

    private ChannelControlPanel getChannel1ControlPanel() {
        if (this.mChannel1ControlPanel == null) {
            this.mChannel1ControlPanel = new ChannelControlPanel();
        }
        return this.mChannel1ControlPanel;
    }

    private ChannelControlPanel getChannel2ControlPanel() {
        if (this.mChannel2ControlPanel == null) {
            this.mChannel2ControlPanel = new ChannelControlPanel();
        }
        return this.mChannel2ControlPanel;
    }

    public static void main(String[] args) {
        SynthesizerViewer frame = new SynthesizerViewer();
        EventQueue.invokeLater(() -> {
            frame.setVisible(true);
            frame.start();
        });
    }

    public class DataGenerationManager
    implements Runnable {
        private TwoChannelSynthesizerM2 mSynthesizer;
        private FS4DownConverter mFS4DownConverter = new FS4DownConverter();
        private int mSamplesPerCycle = 500;

        public DataGenerationManager() {
            try {
                float[] taps = FilterFactory.getSincM2Synthesizer(25000.0, 12500.0, 2, 12);
                this.mSynthesizer = new TwoChannelSynthesizerM2(taps);
            }
            catch (FilterDesignException fde) {
                mLog.error("Filter design error", (Throwable)fde);
            }
        }

        @Override
        public void run() {
            ComplexSamples channel1Buffer = SynthesizerViewer.this.getChannel1ControlPanel().getOscillator().generateComplexSamples(this.mSamplesPerCycle, 0L);
            ComplexSamples channel2Buffer = SynthesizerViewer.this.getChannel2ControlPanel().getOscillator().generateComplexSamples(this.mSamplesPerCycle, 0L);
            ComplexSamples synthesizedBuffer = this.mSynthesizer.process(channel1Buffer, channel2Buffer);
            SynthesizerViewer.this.getChannel1Panel().receive(new FloatNativeBuffer(channel1Buffer));
            SynthesizerViewer.this.getChannel2Panel().receive(new FloatNativeBuffer(channel2Buffer));
            SynthesizerViewer.this.getSpectrumPanel().receive(new FloatNativeBuffer(synthesizedBuffer));
        }
    }

    public class PrimarySpectrumPanel
    extends JPanel
    implements Listener<INativeBuffer> {
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;

        public PrimarySpectrumPanel(SettingsManager settingsManager) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(16.0);
            this.add(this.mSpectrumPanel);
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDftProcessor.setFrameRate(20);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            this.mComplexDftProcessor.receive(nativeBuffer);
        }
    }

    public class ChannelPanel
    extends JPanel
    implements Listener<INativeBuffer> {
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;
        private boolean mLoggingEnabled = false;

        public ChannelPanel(SettingsManager settingsManager, ChannelControlPanel channelControlPanel) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill][]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(16.0);
            this.add((Component)this.mSpectrumPanel, "wrap");
            this.add(channelControlPanel);
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDftProcessor.setFrameRate(20);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            this.mComplexDftProcessor.receive(nativeBuffer);
        }
    }

    public class ChannelControlPanel
    extends JPanel {
        private static final int MIN_FREQUENCY = -6250;
        private static final int MAX_FREQUENCY = 6250;
        private static final int DEFAULT_FREQUENCY = 50;
        private IComplexOscillator mOscillator = OscillatorFactory.getComplexOscillator(50.0, 25000.0);

        public ChannelControlPanel() {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
            this.add((Component)new JLabel("Tone:"), "align right");
            final SpinnerNumberModel model = new SpinnerNumberModel(50, -6250, 6250, 100);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    long toneFrequency = model.getNumber().longValue();
                    ChannelControlPanel.this.mOscillator.setFrequency(toneFrequency);
                }
            });
            JSpinner spinner = new JSpinner(model);
            this.add(spinner);
            this.add(new JLabel("Hz"));
        }

        public IComplexOscillator getOscillator() {
            return this.mOscillator;
        }
    }
}

