/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideSplitPane;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.DuplicateCallDetector;
import io.github.dsheirer.audio.broadcast.AudioStreamingManager;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastStatusPanel;
import io.github.dsheirer.audio.playback.AudioPlaybackManager;
import io.github.dsheirer.controller.ControllerPanel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelAutoStartFrame;
import io.github.dsheirer.controller.channel.ChannelException;
import io.github.dsheirer.controller.channel.ChannelSelectionManager;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.JavaFxWindowManager;
import io.github.dsheirer.gui.icon.ViewIconManagerRequest;
import io.github.dsheirer.gui.playlist.ViewPlaylistRequest;
import io.github.dsheirer.gui.preference.CalibrateRequest;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.gui.preference.calibration.CalibrationDialog;
import io.github.dsheirer.gui.viewer.ViewRecordingViewerRequest;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.log.ApplicationLog;
import io.github.dsheirer.map.MapService;
import io.github.dsheirer.module.log.EventLogManager;
import io.github.dsheirer.monitor.ResourceMonitor;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.record.AudioRecordingManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerSpectralDisplayManager;
import io.github.dsheirer.spectrum.DisableSpectrumWaterfallMenuItem;
import io.github.dsheirer.spectrum.ShowTunerMenuItem;
import io.github.dsheirer.spectrum.SpectralDisplayPanel;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.util.TimeStamp;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.control.ButtonType;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jiconfont.IconCode;
import jiconfont.IconFont;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDRTrunk
implements Listener<TunerEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(SDRTrunk.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(SDRTrunk.class);
    private static final String PREFERENCE_BROADCAST_STATUS_VISIBLE = "sdrtrunk.broadcast.status.visible";
    private static final String PREFERENCE_NOW_PLAYING_DETAILS_VISIBLE = "sdrtrunk.now.playing.details.visible";
    private static final String PREFERENCE_RESOURCE_STATUS_VISIBLE = "sdrtrunk.resource.status.visible";
    private static final String BASE_WINDOW_NAME = "sdrtrunk.main.window";
    private static final String CONTROLLER_PANEL_IDENTIFIER = "sdrtrunk.main.window.control.panel";
    private static final String SPECTRAL_PANEL_IDENTIFIER = "sdrtrunk.main.window.spectral.panel";
    private static final String WINDOW_FRAME_IDENTIFIER = "sdrtrunk.main.window.frame";
    private boolean mBroadcastStatusVisible;
    private boolean mResourceStatusVisible;
    private boolean mNowPlayingDetailsVisible;
    private AudioRecordingManager mAudioRecordingManager;
    private AudioStreamingManager mAudioStreamingManager;
    private BroadcastStatusPanel mBroadcastStatusPanel;
    private ControllerPanel mControllerPanel;
    private IconModel mIconModel = new IconModel();
    private PlaylistManager mPlaylistManager;
    private SettingsManager mSettingsManager;
    private SpectralDisplayPanel mSpectralPanel;
    private JFrame mMainGui;
    private JideSplitPane mSplitPane;
    private JavaFxWindowManager mJavaFxWindowManager;
    private UserPreferences mUserPreferences = new UserPreferences();
    private TunerManager mTunerManager;
    private ApplicationLog mApplicationLog;
    private ResourceMonitor mResourceMonitor;
    private JFXPanel mResourceStatusPanel;
    private String mTitle;

    public SDRTrunk() {
        CalibrationManager calibrationManager;
        if (!GraphicsEnvironment.isHeadless()) {
            this.mMainGui = new JFrame();
        }
        this.mApplicationLog = new ApplicationLog(this.mUserPreferences);
        this.mApplicationLog.start();
        this.mResourceMonitor = new ResourceMonitor(this.mUserPreferences);
        String operatingSystem = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (operatingSystem.contains("mac") || operatingSystem.contains("nux")) {
            try {
                UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
                LookAndFeelFactory.installJideExtension();
            }
            catch (Exception e) {
                mLog.error("Error trying to set Metal look and feel for OS [" + operatingSystem + "]");
            }
        }
        ThreadPool.logSettings();
        this.loadProperties();
        SystemProperties.getInstance().logCurrentSettings();
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        this.mTunerManager = new TunerManager(this.mUserPreferences);
        this.mTunerManager.start();
        this.mSettingsManager = new SettingsManager();
        AliasModel aliasModel = new AliasModel();
        EventLogManager eventLogManager = new EventLogManager(aliasModel, this.mUserPreferences);
        this.mPlaylistManager = new PlaylistManager(this.mUserPreferences, this.mTunerManager, aliasModel, eventLogManager, this.mIconModel);
        if (!GraphicsEnvironment.isHeadless()) {
            this.mJavaFxWindowManager = new JavaFxWindowManager(this.mUserPreferences, this.mTunerManager, this.mPlaylistManager);
        }
        boolean calibrating = !(calibrationManager = CalibrationManager.getInstance(this.mUserPreferences)).isCalibrated() && !this.mUserPreferences.getVectorCalibrationPreference().isHideCalibrationDialog();
        new ChannelSelectionManager(this.mPlaylistManager.getChannelModel());
        AudioPlaybackManager audioPlaybackManager = new AudioPlaybackManager(this.mUserPreferences);
        this.mAudioRecordingManager = new AudioRecordingManager(this.mUserPreferences);
        this.mAudioRecordingManager.start();
        this.mAudioStreamingManager = new AudioStreamingManager(this.mPlaylistManager.getBroadcastModel(), BroadcastFormat.MP3, this.mUserPreferences);
        this.mAudioStreamingManager.start();
        DuplicateCallDetector duplicateCallDetector = new DuplicateCallDetector(this.mUserPreferences);
        this.mPlaylistManager.getChannelProcessingManager().addAudioSegmentListener(duplicateCallDetector);
        this.mPlaylistManager.getChannelProcessingManager().addAudioSegmentListener(audioPlaybackManager);
        this.mPlaylistManager.getChannelProcessingManager().addAudioSegmentListener(this.mAudioRecordingManager);
        this.mPlaylistManager.getChannelProcessingManager().addAudioSegmentListener(this.mAudioStreamingManager);
        MapService mapService = new MapService(this.mIconModel);
        this.mPlaylistManager.getChannelProcessingManager().addDecodeEventListener(mapService);
        this.mNowPlayingDetailsVisible = this.mPreferences.getBoolean(PREFERENCE_NOW_PLAYING_DETAILS_VISIBLE, true);
        if (!GraphicsEnvironment.isHeadless()) {
            this.mControllerPanel = new ControllerPanel(this.mPlaylistManager, audioPlaybackManager, this.mIconModel, mapService, this.mSettingsManager, this.mTunerManager, this.mUserPreferences, this.mNowPlayingDetailsVisible);
        }
        this.mSpectralPanel = new SpectralDisplayPanel(this.mPlaylistManager, this.mSettingsManager, this.mTunerManager.getDiscoveredTunerModel());
        TunerSpectralDisplayManager tunerSpectralDisplayManager = new TunerSpectralDisplayManager(this.mSpectralPanel, this.mPlaylistManager, this.mSettingsManager, this.mTunerManager.getDiscoveredTunerModel());
        this.mTunerManager.getDiscoveredTunerModel().addListener(tunerSpectralDisplayManager);
        this.mTunerManager.getDiscoveredTunerModel().addListener(this);
        this.mPlaylistManager.init();
        if (GraphicsEnvironment.isHeadless()) {
            mLog.info("starting main application headless");
        } else {
            mLog.info("starting main application gui");
            this.initGUI();
        }
        EventQueue.invokeLater(() -> {
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    this.mMainGui.setVisible(true);
                    Tuner tuner = tunerSpectralDisplayManager.showFirstTuner();
                    if (tuner != null) {
                        this.updateTitle(tuner.getPreferredName());
                    }
                }
                if (calibrating && !GraphicsEnvironment.isHeadless()) {
                    Platform.runLater(() -> {
                        CalibrationDialog calibrationDialog = this.mJavaFxWindowManager.getCalibrationDialog(this.mUserPreferences);
                        Optional calibrate = calibrationDialog.showAndWait();
                        if (calibrate.isPresent() && ((ButtonType)calibrate.get()).getText().equals("Calibrate")) {
                            MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest(PreferenceEditorType.VECTOR_CALIBRATION));
                            MyEventBus.getGlobalEventBus().post((Object)new CalibrateRequest());
                        } else {
                            this.autoStartChannels();
                        }
                    });
                } else {
                    this.autoStartChannels();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void autoStartChannels() {
        List<Channel> channels = this.mPlaylistManager.getChannelModel().getAutoStartChannels();
        if (channels.size() > 0) {
            if (GraphicsEnvironment.isHeadless()) {
                for (Channel channel : channels) {
                    try {
                        mLog.info("Auto-starting channel " + channel.getName());
                        this.mPlaylistManager.getChannelProcessingManager().start(channel);
                    }
                    catch (ChannelException ce) {
                        mLog.error("Channel: " + channel.getName() + " auto-start failed: " + ce.getMessage());
                    }
                }
            } else {
                new ChannelAutoStartFrame(this.mPlaylistManager.getChannelProcessingManager(), channels, this.mUserPreferences);
            }
        }
    }

    private void initGUI() {
        this.mMainGui.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0 ", "[grow,fill]", "[grow,fill]0[shrink 0]"));
        this.mTitle = SystemProperties.getInstance().getApplicationName();
        this.mMainGui.setTitle(this.mTitle);
        Point location = this.mUserPreferences.getSwingPreference().getLocation(WINDOW_FRAME_IDENTIFIER);
        if (location != null) {
            this.mMainGui.setLocation(location);
        } else {
            this.mMainGui.setLocationRelativeTo(null);
        }
        this.mMainGui.setDefaultCloseOperation(3);
        this.mMainGui.addWindowListener(new ShutdownMonitor());
        Dimension dimension = this.mUserPreferences.getSwingPreference().getDimension(WINDOW_FRAME_IDENTIFIER);
        this.mSpectralPanel.setPreferredSize(new Dimension(1280, 300));
        this.mControllerPanel.setPreferredSize(new Dimension(1280, 500));
        if (dimension != null) {
            Dimension controller;
            Dimension spectral = this.mUserPreferences.getSwingPreference().getDimension(SPECTRAL_PANEL_IDENTIFIER);
            if (spectral != null) {
                this.mSpectralPanel.setSize(spectral);
            }
            if ((controller = this.mUserPreferences.getSwingPreference().getDimension(CONTROLLER_PANEL_IDENTIFIER)) != null) {
                this.mControllerPanel.setSize(controller);
            }
            this.mMainGui.setSize(dimension);
            if (this.mUserPreferences.getSwingPreference().getMaximized(WINDOW_FRAME_IDENTIFIER, false)) {
                this.mMainGui.setExtendedState(6);
            }
        } else {
            this.mMainGui.setSize(new Dimension(1280, 800));
        }
        this.mSplitPane = new JideSplitPane(0);
        this.mSplitPane.setDividerSize(5);
        this.mSplitPane.add((Component)this.mSpectralPanel);
        this.mSplitPane.add((Component)this.mControllerPanel);
        this.mBroadcastStatusVisible = this.mPreferences.getBoolean(PREFERENCE_BROADCAST_STATUS_VISIBLE, false);
        if (this.mBroadcastStatusVisible) {
            this.mSplitPane.add((Component)this.getBroadcastStatusPanel());
        }
        this.mMainGui.add((Component)this.mSplitPane, "cell 0 0,span,grow");
        this.mResourceMonitor.start();
        this.mResourceStatusVisible = this.mPreferences.getBoolean(PREFERENCE_RESOURCE_STATUS_VISIBLE, true);
        if (this.mResourceStatusVisible) {
            this.mMainGui.add((Component)this.getResourceStatusPanel(), "span,growx");
        }
        JMenuBar menuBar = new JMenuBar();
        this.mMainGui.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem exitMenu = new JMenuItem("Exit");
        exitMenu.addActionListener(event -> {
            this.processShutdown();
            System.exit(0);
        });
        fileMenu.add(exitMenu);
        JMenu viewMenu = new JMenu("View");
        JMenuItem viewPlaylistItem = new JMenuItem("Playlist Editor");
        viewPlaylistItem.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.PLAY_CIRCLE_O, (float)12.0f));
        viewPlaylistItem.addActionListener(e -> MyEventBus.getGlobalEventBus().post((Object)new ViewPlaylistRequest()));
        viewMenu.add(viewPlaylistItem);
        viewMenu.add(new JSeparator());
        JMenuItem viewApplicationLogsMenu = new JMenuItem("Application Log Files");
        viewApplicationLogsMenu.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FOLDER_OPEN_O, (float)12.0f));
        viewApplicationLogsMenu.addActionListener(arg0 -> {
            File logsDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationLog().toFile();
            try {
                Desktop.getDesktop().open(logsDirectory);
            }
            catch (Exception e) {
                mLog.error("Couldn't open file explorer");
                JOptionPane.showMessageDialog(this.mMainGui, "Can't launch file explorer - files are located at: " + String.valueOf(logsDirectory), "Can't launch file explorer", 0);
            }
        });
        viewMenu.add(viewApplicationLogsMenu);
        JMenuItem viewRecordingsMenuItem = new JMenuItem("Audio Recordings");
        viewRecordingsMenuItem.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FOLDER_OPEN_O, (float)12.0f));
        viewRecordingsMenuItem.addActionListener(arg0 -> {
            File recordingsDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryRecording().toFile();
            try {
                Desktop.getDesktop().open(recordingsDirectory);
            }
            catch (Exception e) {
                mLog.error("Couldn't open file explorer");
                JOptionPane.showMessageDialog(this.mMainGui, "Can't launch file explorer - files are located at: " + String.valueOf(recordingsDirectory), "Can't launch file explorer", 0);
            }
        });
        viewMenu.add(viewRecordingsMenuItem);
        JMenuItem viewEventLogsMenu = new JMenuItem("Channel Event Log Files");
        viewEventLogsMenu.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FOLDER_OPEN_O, (float)12.0f));
        viewEventLogsMenu.addActionListener(arg0 -> {
            File eventLogsDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryEventLog().toFile();
            try {
                Desktop.getDesktop().open(eventLogsDirectory);
            }
            catch (Exception e) {
                mLog.error("Couldn't open file explorer");
                JOptionPane.showMessageDialog(this.mMainGui, "Can't launch file explorer - files are located at: " + String.valueOf(eventLogsDirectory), "Can't launch file explorer", 0);
            }
        });
        viewMenu.add(viewEventLogsMenu);
        JMenuItem iconManagerMenu = new JMenuItem("Icon Manager");
        iconManagerMenu.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.PICTURE_O, (float)12.0f));
        iconManagerMenu.addActionListener(arg0 -> MyEventBus.getGlobalEventBus().post((Object)new ViewIconManagerRequest()));
        viewMenu.add(iconManagerMenu);
        JMenuItem recordingViewerMenu = new JMenuItem("Message Recording Viewer (.bits)");
        recordingViewerMenu.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.BRAILLE, (float)12.0f));
        recordingViewerMenu.addActionListener(e -> MyEventBus.getGlobalEventBus().post((Object)new ViewRecordingViewerRequest()));
        viewMenu.add(recordingViewerMenu);
        JMenuItem viewScreenCapturesMenu = new JMenuItem("Screen Captures");
        viewScreenCapturesMenu.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FOLDER_OPEN_O, (float)12.0f));
        viewScreenCapturesMenu.addActionListener(arg0 -> {
            File screenCapturesDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryScreenCapture().toFile();
            try {
                Desktop.getDesktop().open(screenCapturesDirectory);
            }
            catch (Exception e) {
                mLog.error("Couldn't open file explorer");
                JOptionPane.showMessageDialog(this.mMainGui, "Can't launch file explorer - files are located at: " + String.valueOf(screenCapturesDirectory), "Can't launch file explorer", 0);
            }
        });
        viewMenu.add(viewScreenCapturesMenu);
        JMenuItem preferencesItem = new JMenuItem("User Preferences");
        preferencesItem.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.COG, (float)12.0f));
        preferencesItem.addActionListener(e -> MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest()));
        viewMenu.add(preferencesItem);
        viewMenu.add(new JSeparator());
        viewMenu.add(new TunersMenu());
        viewMenu.add(new JSeparator());
        viewMenu.add(new DisableSpectrumWaterfallMenuItem(this.mSpectralPanel));
        viewMenu.add(new NowPlayingChannelDetailsVisibleMenuItem());
        viewMenu.add(new BroadcastStatusVisibleMenuItem());
        viewMenu.add(new ResourceStatusVisibleMenuItem());
        menuBar.add(viewMenu);
        JMenuItem screenCaptureItem = new JMenuItem("Screen Capture");
        screenCaptureItem.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.CAMERA, (float)12.0f));
        screenCaptureItem.setMnemonic(67);
        screenCaptureItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        screenCaptureItem.setMaximumSize(screenCaptureItem.getPreferredSize());
        screenCaptureItem.addActionListener(arg0 -> {
            try {
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(this.mMainGui.getBounds());
                String filename = TimeStamp.getTimeStamp("_") + "_screen_capture.png";
                Path captureFile = this.mUserPreferences.getDirectoryPreference().getDirectoryScreenCapture().resolve(filename);
                EventQueue.invokeLater(() -> {
                    try {
                        ImageIO.write((RenderedImage)image, "png", captureFile.toFile());
                    }
                    catch (IOException e) {
                        mLog.error("Couldn't write screen capture to file [" + captureFile.toString() + "]", (Throwable)e);
                    }
                });
            }
            catch (AWTException e) {
                mLog.error("Exception while taking screen capture", (Throwable)e);
            }
        });
        menuBar.add(screenCaptureItem);
    }

    private void processShutdown() {
        mLog.info("Application shutdown started ...");
        this.mUserPreferences.getSwingPreference().setLocation(WINDOW_FRAME_IDENTIFIER, this.mMainGui.getLocation());
        this.mUserPreferences.getSwingPreference().setDimension(WINDOW_FRAME_IDENTIFIER, this.mMainGui.getSize());
        this.mUserPreferences.getSwingPreference().setMaximized(WINDOW_FRAME_IDENTIFIER, (this.mMainGui.getExtendedState() & 6) == 6);
        this.mUserPreferences.getSwingPreference().setDimension(SPECTRAL_PANEL_IDENTIFIER, this.mSpectralPanel.getSize());
        this.mUserPreferences.getSwingPreference().setDimension(CONTROLLER_PANEL_IDENTIFIER, this.mControllerPanel.getSize());
        this.mJavaFxWindowManager.shutdown();
        mLog.info("Stopping channels ...");
        this.mPlaylistManager.getChannelProcessingManager().shutdown();
        this.mAudioRecordingManager.stop();
        this.mResourceMonitor.stop();
        mLog.info("Stopping spectral display ...");
        this.mSpectralPanel.clearTuner();
        mLog.info("Stopping tuners ...");
        this.mTunerManager.stop();
        mLog.info("Shutdown complete.");
        this.mApplicationLog.stop();
    }

    private BroadcastStatusPanel getBroadcastStatusPanel() {
        if (this.mBroadcastStatusPanel == null) {
            this.mBroadcastStatusPanel = new BroadcastStatusPanel(this.mPlaylistManager.getBroadcastModel(), this.mUserPreferences, "application.broadcast.status.panel");
            this.mBroadcastStatusPanel.setPreferredSize(new Dimension(880, 70));
            this.mBroadcastStatusPanel.getTable().setEnabled(false);
        }
        return this.mBroadcastStatusPanel;
    }

    private void toggleBroadcastStatusPanelVisibility() {
        this.mBroadcastStatusVisible = !this.mBroadcastStatusVisible;
        EventQueue.invokeLater(() -> {
            if (this.mBroadcastStatusVisible) {
                this.mSplitPane.add((Component)this.getBroadcastStatusPanel());
            } else {
                this.mSplitPane.remove((Component)this.getBroadcastStatusPanel());
            }
            this.mMainGui.revalidate();
        });
        this.mPreferences.putBoolean(PREFERENCE_BROADCAST_STATUS_VISIBLE, this.mBroadcastStatusVisible);
    }

    private JFXPanel getResourceStatusPanel() {
        if (this.mResourceStatusPanel == null) {
            this.mResourceStatusPanel = this.mJavaFxWindowManager.getStatusPanel(this.mResourceMonitor);
        }
        return this.mResourceStatusPanel;
    }

    private void toggleResourceStatusPanelVisibility() {
        this.mResourceStatusVisible = !this.mResourceStatusVisible;
        EventQueue.invokeLater(() -> {
            if (this.mResourceStatusVisible) {
                this.mMainGui.add((Component)this.getResourceStatusPanel(), "span,growx");
            } else {
                this.mMainGui.remove((Component)this.getResourceStatusPanel());
            }
            this.mMainGui.revalidate();
        });
        this.mPreferences.putBoolean(PREFERENCE_RESOURCE_STATUS_VISIBLE, this.mResourceStatusVisible);
    }

    private void toggleNowPlayingDetailsPanelVisibility() {
        this.mNowPlayingDetailsVisible = !this.mNowPlayingDetailsVisible;
        this.mControllerPanel.getNowPlayingPanel().setDetailTabsVisible(this.mNowPlayingDetailsVisible);
        this.mPreferences.putBoolean(PREFERENCE_NOW_PLAYING_DETAILS_VISIBLE, this.mNowPlayingDetailsVisible);
    }

    private void loadProperties() {
        Path propertiesPath = this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationRoot().resolve("SDRTrunk.properties");
        if (!Files.exists(propertiesPath, new LinkOption[0])) {
            try {
                mLog.info("SDRTrunk - creating application properties file [" + String.valueOf(propertiesPath.toAbsolutePath()) + "]");
                Files.createFile(propertiesPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                mLog.error("SDRTrunk - couldn't create application properties file [" + String.valueOf(propertiesPath.toAbsolutePath()), (Throwable)e);
            }
        }
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            SystemProperties.getInstance().load(propertiesPath);
        } else {
            mLog.error("SDRTrunk - couldn't find or recreate the SDRTrunk application properties file");
        }
    }

    private Path getHomePath() {
        Path homePath = FileSystems.getDefault().getPath(System.getProperty("user.home"), "SDRTrunk");
        if (!Files.exists(homePath, new LinkOption[0])) {
            try {
                Files.createDirectory(homePath, new FileAttribute[0]);
                mLog.info("SDRTrunk - created application home directory [" + homePath.toString() + "]");
            }
            catch (Exception e) {
                homePath = null;
                mLog.error("SDRTrunk: exception while creating SDRTrunk home directory in the user's home directory", (Throwable)e);
            }
        }
        return homePath;
    }

    @Override
    public void receive(TunerEvent event) {
        switch (event.getEvent()) {
            case REQUEST_MAIN_SPECTRAL_DISPLAY: {
                this.updateTitle(event.getTuner().getPreferredName());
                break;
            }
            case REQUEST_CLEAR_MAIN_SPECTRAL_DISPLAY: {
                this.updateTitle(null);
                break;
            }
            case NOTIFICATION_SHUTTING_DOWN: {
                Tuner currentTuner = this.mSpectralPanel.getTuner();
                if ((!event.hasTuner() || !event.getTuner().equals(currentTuner)) && currentTuner != null) break;
                this.updateTitle(null);
            }
        }
    }

    private void updateTitle(String tunerName) {
        if (tunerName != null) {
            this.mMainGui.setTitle(this.mTitle + " - " + tunerName);
        } else {
            this.mMainGui.setTitle(this.mTitle);
        }
    }

    public static void main(String[] args) {
        new SDRTrunk();
    }

    public class ShutdownMonitor
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            SDRTrunk.this.processShutdown();
        }
    }

    public class TunersMenu
    extends JMenu {
        public TunersMenu() {
            super("Tuners");
            this.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    TunersMenu.this.removeAll();
                    for (DiscoveredTuner discoveredTuner : SDRTrunk.this.mTunerManager.getAvailableTuners()) {
                        TunersMenu.this.add(new ShowTunerMenuItem(SDRTrunk.this.mTunerManager.getDiscoveredTunerModel(), discoveredTuner.getTuner()));
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
    }

    public class NowPlayingChannelDetailsVisibleMenuItem
    extends JCheckBoxMenuItem {
        public NowPlayingChannelDetailsVisibleMenuItem() {
            super("Show Now Playing Channel Details");
            this.setSelected(SDRTrunk.this.mNowPlayingDetailsVisible);
            this.addActionListener(e -> {
                SDRTrunk.this.toggleNowPlayingDetailsPanelVisibility();
                this.setSelected(SDRTrunk.this.mNowPlayingDetailsVisible);
            });
        }
    }

    public class BroadcastStatusVisibleMenuItem
    extends JCheckBoxMenuItem {
        public BroadcastStatusVisibleMenuItem() {
            super("Show Streaming Status");
            this.setSelected(SDRTrunk.this.mBroadcastStatusVisible);
            this.addActionListener(e -> {
                SDRTrunk.this.toggleBroadcastStatusPanelVisibility();
                this.setSelected(SDRTrunk.this.mBroadcastStatusVisible);
            });
        }
    }

    public class ResourceStatusVisibleMenuItem
    extends JCheckBoxMenuItem {
        public ResourceStatusVisibleMenuItem() {
            super("Show Resource Status");
            this.setSelected(SDRTrunk.this.mResourceStatusVisible);
            this.addActionListener(e -> {
                SDRTrunk.this.toggleResourceStatusPanelVisibility();
                this.setSelected(SDRTrunk.this.mResourceStatusVisible);
            });
        }
    }
}

