/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.controller.channel.map.ChannelRange;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.icon.IconManager;
import io.github.dsheirer.gui.icon.ViewIconManagerRequest;
import io.github.dsheirer.gui.playlist.PlaylistEditor;
import io.github.dsheirer.gui.playlist.PlaylistEditorRequest;
import io.github.dsheirer.gui.playlist.ViewPlaylistRequest;
import io.github.dsheirer.gui.playlist.channelMap.ChannelMapEditor;
import io.github.dsheirer.gui.playlist.channelMap.ViewChannelMapEditorRequest;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.UserPreferencesEditor;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.gui.preference.calibration.CalibrationDialog;
import io.github.dsheirer.gui.viewer.RecordingViewer;
import io.github.dsheirer.gui.viewer.ViewRecordingViewerRequest;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.jmbe.JmbeEditor;
import io.github.dsheirer.jmbe.JmbeEditorRequest;
import io.github.dsheirer.module.log.EventLogManager;
import io.github.dsheirer.monitor.ResourceMonitor;
import io.github.dsheirer.monitor.StatusBox;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import jiconfont.IconFont;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconFontFX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFxWindowManager
extends Application {
    private static final Logger mLog = LoggerFactory.getLogger(JavaFxWindowManager.class);
    public static final String CHANNEL_MAP_EDITOR = "channelmap";
    public static final String ICON_MANAGER = "iconmanager";
    public static final String PLAYLIST_EDITOR = "playlist";
    public static final String USER_PREFERENCES_EDITOR = "preferences";
    public static final String STAGE_MONITOR_KEY_CALIBRATION_DIALOG = "calibration.dialog";
    public static final String STAGE_MONITOR_KEY_CHANNEL_MAP_EDITOR = "channel.map";
    public static final String STAGE_MONITOR_KEY_RECORDING_VIEWER = "recording.viewer";
    public static final String STAGE_MONITOR_KEY_ICON_MANAGER_EDITOR = "icon.manager";
    public static final String STAGE_MONITOR_KEY_JMBE_EDITOR = "jmbe.editor";
    public static final String STAGE_MONITOR_KEY_PLAYLIST_EDITOR = "playlist";
    public static final String STAGE_MONITOR_KEY_USER_PREFERENCES_EDITOR = "user.preferences";
    private JFXPanel mJFXPanel;
    private ChannelMapEditor mChannelMapEditor;
    private IconManager mIconManager;
    private JmbeEditor mJmbeEditor;
    private PlaylistEditor mPlaylistEditor;
    private PlaylistManager mPlaylistManager;
    private TunerManager mTunerManager;
    private UserPreferences mUserPreferences;
    private UserPreferencesEditor mUserPreferencesEditor;
    private RecordingViewer mRecordingViewer;
    private Stage mChannelMapStage;
    private Stage mIconManagerStage;
    private Stage mJmbeEditorStage;
    private Stage mPlaylistStage;
    private Stage mUserPreferencesStage;
    private Stage mRecordingViewerStage;
    private JFXPanel mStatusPanel;

    public JavaFxWindowManager(UserPreferences userPreferences, TunerManager tunerManager, PlaylistManager playlistManager) {
        this.mUserPreferences = userPreferences;
        this.mTunerManager = tunerManager;
        this.mPlaylistManager = playlistManager;
        this.setup();
    }

    public JavaFxWindowManager() {
        this.mUserPreferences = new UserPreferences();
        AliasModel aliasModel = new AliasModel();
        EventLogManager eventLogManager = new EventLogManager(aliasModel, this.mUserPreferences);
        this.mTunerManager = new TunerManager(this.mUserPreferences);
        this.mTunerManager.start();
        this.mPlaylistManager = new PlaylistManager(this.mUserPreferences, this.mTunerManager, aliasModel, eventLogManager, new IconModel());
        this.mPlaylistManager.init();
        this.setup();
    }

    public JFXPanel getStatusPanel(ResourceMonitor resourceMonitor) {
        if (this.mStatusPanel == null) {
            this.mStatusPanel = new JFXPanel();
            Platform.runLater(() -> {
                Scene scene = new Scene((Parent)new StatusBox(resourceMonitor));
                this.mStatusPanel.setScene(scene);
            });
        }
        return this.mStatusPanel;
    }

    private void setup() {
        MyEventBus.getGlobalEventBus().register((Object)this);
        IconFontFX.register((IconFont)FontAwesome.getIconFont());
        this.createJFXPanel();
    }

    private void execute(Runnable runnable) {
        this.createJFXPanel();
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private void createJFXPanel() {
        if (this.mJFXPanel == null) {
            this.mJFXPanel = new JFXPanel();
            Platform.setImplicitExit((boolean)false);
        }
    }

    public void shutdown() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        this.mUserPreferences.getJavaFxPreferences().clearStageMonitors();
        Platform.exit();
    }

    public CalibrationDialog getCalibrationDialog(UserPreferences userPreferences) {
        this.createJFXPanel();
        return new CalibrationDialog(userPreferences);
    }

    public Stage getRecordingViewerStage() {
        if (this.mRecordingViewerStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getRecordingViewer(), 1100.0, 800.0);
            this.mRecordingViewerStage = new Stage();
            this.mRecordingViewerStage.setTitle("sdrtrunk - Message Recording Viewer (.bits)");
            this.mRecordingViewerStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mRecordingViewerStage, STAGE_MONITOR_KEY_RECORDING_VIEWER);
        }
        return this.mRecordingViewerStage;
    }

    public RecordingViewer getRecordingViewer() {
        if (this.mRecordingViewer == null) {
            this.mRecordingViewer = new RecordingViewer();
        }
        return this.mRecordingViewer;
    }

    public Stage getIconManagerStage() {
        if (this.mIconManagerStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getIconManager(), 500.0, 500.0);
            this.mIconManagerStage = new Stage();
            this.mIconManagerStage.setTitle("sdrtrunk - Icon Manager");
            this.mIconManagerStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mIconManagerStage, STAGE_MONITOR_KEY_ICON_MANAGER_EDITOR);
        }
        return this.mIconManagerStage;
    }

    public IconManager getIconManager() {
        if (this.mIconManager == null) {
            this.mIconManager = new IconManager(this.mPlaylistManager.getIconModel());
        }
        return this.mIconManager;
    }

    @Subscribe
    public void process(JmbeEditorRequest request) {
        if (request.isCloseEditorRequest()) {
            this.execute(() -> {
                this.getJmbeEditorStage().hide();
                this.mJmbeEditorStage = null;
                this.mJmbeEditor = null;
            });
        } else {
            this.execute(() -> {
                this.restoreStage(this.getJmbeEditorStage());
                this.getJmbeEditor().process(request);
            });
        }
    }

    public Stage getJmbeEditorStage() {
        if (this.mJmbeEditorStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getJmbeEditor(), 650.0, 650.0);
            this.mJmbeEditorStage = new Stage();
            this.mJmbeEditorStage.setTitle("sdrtrunk - JMBE Library Updater");
            this.mJmbeEditorStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mJmbeEditorStage, STAGE_MONITOR_KEY_JMBE_EDITOR);
        }
        return this.mJmbeEditorStage;
    }

    public JmbeEditor getJmbeEditor() {
        if (this.mJmbeEditor == null) {
            this.mJmbeEditor = new JmbeEditor(this.mUserPreferences);
        }
        return this.mJmbeEditor;
    }

    public PlaylistEditor getPlaylistEditor() {
        if (this.mPlaylistEditor == null) {
            this.mPlaylistEditor = new PlaylistEditor(this.mPlaylistManager, this.mTunerManager, this.mUserPreferences);
        }
        return this.mPlaylistEditor;
    }

    private Stage getPlaylistStage() {
        if (this.mPlaylistStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getPlaylistEditor(), 1000.0, 750.0);
            this.mPlaylistStage = new Stage();
            this.mPlaylistStage.setTitle("sdrtrunk - Playlist Editor");
            this.mPlaylistStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mPlaylistStage, "playlist");
        }
        return this.mPlaylistStage;
    }

    @Subscribe
    public void process(PlaylistEditorRequest request) {
        this.execute(() -> {
            try {
                this.restoreStage(this.getPlaylistStage());
                this.getPlaylistEditor().process(request);
            }
            catch (Throwable t) {
                mLog.error("Error processing show playlist editor request", t);
            }
        });
    }

    private UserPreferencesEditor getUserPreferencesEditor() {
        if (this.mUserPreferencesEditor == null) {
            this.mUserPreferencesEditor = new UserPreferencesEditor(this.mUserPreferences);
        }
        return this.mUserPreferencesEditor;
    }

    private Stage getUserPreferencesStage() {
        if (this.mUserPreferencesStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getUserPreferencesEditor(), 900.0, 500.0);
            this.mUserPreferencesStage = new Stage();
            this.mUserPreferencesStage.setTitle("sdrtrunk - User Preferences");
            this.mUserPreferencesStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mUserPreferencesStage, STAGE_MONITOR_KEY_USER_PREFERENCES_EDITOR);
        }
        return this.mUserPreferencesStage;
    }

    @Subscribe
    public void process(ViewUserPreferenceEditorRequest request) {
        this.execute(() -> {
            this.restoreStage(this.getUserPreferencesStage());
            this.getUserPreferencesEditor().process(request);
        });
    }

    private ChannelMapEditor getChannelMapEditor() {
        if (this.mChannelMapEditor == null) {
            this.mChannelMapEditor = new ChannelMapEditor(this.mPlaylistManager.getChannelMapModel());
        }
        return this.mChannelMapEditor;
    }

    private Stage getChannelMapStage() {
        if (this.mChannelMapStage == null) {
            this.createJFXPanel();
            Scene scene = new Scene((Parent)this.getChannelMapEditor(), 500.0, 500.0);
            this.mChannelMapStage = new Stage();
            this.mChannelMapStage.setTitle("sdrtrunk - Channel Map Editor");
            this.mChannelMapStage.setScene(scene);
            this.mUserPreferences.getJavaFxPreferences().monitor(this.mChannelMapStage, STAGE_MONITOR_KEY_CHANNEL_MAP_EDITOR);
        }
        return this.mChannelMapStage;
    }

    @Subscribe
    public void process(ViewIconManagerRequest request) {
        this.execute(() -> this.restoreStage(this.getIconManagerStage()));
    }

    @Subscribe
    public void process(ViewChannelMapEditorRequest request) {
        this.execute(() -> {
            this.restoreStage(this.getChannelMapStage());
            this.getChannelMapEditor().process(request);
        });
    }

    @Subscribe
    public void process(ViewRecordingViewerRequest request) {
        this.execute(() -> this.restoreStage(this.getRecordingViewerStage()));
    }

    private void restoreStage(Stage stage) {
        stage.setIconified(false);
        stage.show();
        stage.requestFocus();
        stage.toFront();
        stage.setMinHeight(stage.getHeight());
        stage.setMinWidth(stage.getWidth());
    }

    public void start(Stage primaryStage) throws Exception {
        String window;
        mLog.debug("Starting ...");
        Application.Parameters parameters = this.getParameters();
        mLog.debug("Parameters: " + (parameters != null));
        boolean valid = false;
        if (parameters != null && parameters.getRaw().size() == 1 && (window = (String)parameters.getRaw().get(0)) != null) {
            switch (window) {
                case "channelmap": {
                    ChannelMap channelMap1 = new ChannelMap("Test Map 1");
                    channelMap1.addRange(new ChannelRange(1, 199, 150000000, 12500));
                    channelMap1.addRange(new ChannelRange(200, 299, 160000000, 25000));
                    channelMap1.addRange(new ChannelRange(300, 399, 170000000, 12500));
                    channelMap1.addRange(new ChannelRange(400, 499, 180000000, 25000));
                    this.mPlaylistManager.getChannelMapModel().addChannelMap(channelMap1);
                    ChannelMap channelMap2 = new ChannelMap("Test Map 2");
                    channelMap2.addRange(new ChannelRange(1, 199, 450000000, 12500));
                    channelMap2.addRange(new ChannelRange(200, 299, 460000000, 25000));
                    channelMap2.addRange(new ChannelRange(300, 399, 470000000, 12500));
                    channelMap2.addRange(new ChannelRange(400, 499, 480000000, 25000));
                    this.mPlaylistManager.getChannelMapModel().addChannelMap(channelMap2);
                    valid = true;
                    this.process(new ViewChannelMapEditorRequest());
                    break;
                }
                case "iconmanager": {
                    valid = true;
                    this.process(new ViewIconManagerRequest());
                    break;
                }
                case "playlist": {
                    valid = true;
                    this.process(new ViewPlaylistRequest());
                    break;
                }
                case "preferences": {
                    valid = true;
                    this.process(new ViewUserPreferenceEditorRequest(PreferenceEditorType.DEFAULT));
                    break;
                }
            }
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder();
            sb.append("An argument is required to launch JavaFX windows from this window manager.  Valid options are:\n\tchannelmap\tChannel Map Editor\n\ticonmanager\tIcon Manager\n\tplaylist\tPlaylist Editor\n\tpreferences\tUser Preferences Editor\n");
            sb.append("Supplied Argument(s): ").append(parameters.getRaw());
            mLog.error(sb.toString());
        }
    }

    public static void main(String[] args) {
        mLog.info("Application Start - Parameters: " + String.valueOf(args));
        JavaFxWindowManager.launch((String[])args);
    }
}

