/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.SyncLossMessage;
import java.util.function.Function;

public class SyncLossMessageFilter
extends Filter<IMessage, String> {
    private static final String SYNC_LOSS_KEY = "Sync-Loss";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public SyncLossMessageFilter() {
        super("Sync Loss Messages");
        this.add(new FilterElement<String>(SYNC_LOSS_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof SyncLossMessage;
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(SyncLossMessageFilter syncLossMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof SyncLossMessage) {
                return SyncLossMessageFilter.SYNC_LOSS_KEY;
            }
            return null;
        }
    }
}

