/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.IFilter;
import io.github.dsheirer.filter.IFilterChangeListener;
import io.github.dsheirer.log.LoggingSuppressor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSet<T>
implements IFilter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSet.class);
    private static LoggingSuppressor sLoggingSuppressor = new LoggingSuppressor(LOGGER);
    private List<IFilter<T>> mFilters = new ArrayList<IFilter<T>>();
    private String mName;
    private IFilterChangeListener mFilterChangeListener;

    public FilterSet(String name) {
        this.mName = name;
    }

    public FilterSet(IFilter<T> filter) {
        this("Filters");
        this.addFilter(filter);
    }

    @Override
    public void register(IFilterChangeListener listener) {
        this.mFilterChangeListener = listener;
        for (IFilter<T> child : this.mFilters) {
            child.register(listener);
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean passes(T t) {
        for (IFilter<T> filter : this.mFilters) {
            if (!filter.canProcess(t)) continue;
            return filter.passes(t);
        }
        return false;
    }

    @Override
    public boolean canProcess(T t) {
        for (IFilter<T> filter : this.mFilters) {
            if (!filter.canProcess(t)) continue;
            return true;
        }
        sLoggingSuppressor.info(t.getClass().getSimpleName(), 1, "FilterSet [" + this.getClass().getSimpleName() + "] has no filter element for items of type [" + t.getClass().getSimpleName() + "]");
        return false;
    }

    public List<IFilter<T>> getFilters() {
        return new ArrayList<IFilter<T>>(this.mFilters);
    }

    public void addFilters(List<IFilter<T>> filters) {
        for (IFilter<T> filter : filters) {
            this.addFilter(filter);
        }
    }

    public void addFilter(IFilter<T> filter) {
        Filter filterInstance;
        if (filter instanceof Filter && (filterInstance = (Filter)filter).getKeyExtractor() == null) {
            LOGGER.warn("Filter [" + String.valueOf(filter.getClass()) + "] has a null key extractor");
        }
        this.mFilters.add(filter);
        filter.register(this.mFilterChangeListener);
    }

    @Override
    public boolean isEnabled() {
        for (IFilter<T> filter : this.mFilters) {
            if (!filter.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnabledCount() {
        int count = 0;
        for (IFilter<T> filter : this.mFilters) {
            count += filter.getEnabledCount();
        }
        return count;
    }

    @Override
    public int getElementCount() {
        int count = 0;
        for (IFilter<T> filter : this.mFilters) {
            count += filter.getElementCount();
        }
        return count;
    }
}

