/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import io.github.dsheirer.edac.trellis.Node;
import io.github.dsheirer.edac.trellis.Path;
import org.apache.commons.math3.util.FastMath;

public abstract class ViterbiDecoder {
    private int mInputBitLength;
    private int mInputValueCount;
    private int mOutputBitLength;
    private int mOutputValueCount;

    public ViterbiDecoder(int inputBitLength, int outputBitLength) {
        this.mInputBitLength = inputBitLength;
        this.mOutputBitLength = outputBitLength;
        this.mInputValueCount = (int)FastMath.pow((double)2.0, (int)this.mInputBitLength);
        this.mOutputValueCount = (int)FastMath.pow((double)2.0, (int)this.mOutputBitLength);
    }

    protected abstract Node createNode(int var1, int var2);

    protected abstract Node createFlushingNode(int var1);

    protected abstract Node createStartingNode();

    public int getInputBitLength() {
        return this.mInputBitLength;
    }

    public int getInputValueCount() {
        return this.mInputValueCount;
    }

    public int getOutputBitLength() {
        return this.mOutputBitLength;
    }

    public int getOutputValueCount() {
        return this.mOutputValueCount;
    }

    public Path decode(int[] transmittedOutputValues) {
        Path[] survivingPaths = new Path[this.getInputValueCount()];
        survivingPaths[0] = new Path(this.createStartingNode());
        for (int x = 0; x < transmittedOutputValues.length - 1; ++x) {
            survivingPaths = this.add(survivingPaths, transmittedOutputValues[x]);
        }
        return this.flush(survivingPaths, transmittedOutputValues[transmittedOutputValues.length - 1]);
    }

    public Path[] add(Path[] previousPaths, int transmittedOutputValue) {
        Path[] survivorPaths = new Path[this.getInputValueCount()];
        for (int x = 0; x < this.getInputValueCount(); ++x) {
            Node node = this.createNode(x, transmittedOutputValue);
            for (Path path : previousPaths) {
                if (path == null) continue;
                Path pathToEvaluate = path.copyOf();
                pathToEvaluate.add(node);
                if (survivorPaths[node.getInputValue()] != null) {
                    Path survivingPath = survivorPaths[node.getInputValue()];
                    if (pathToEvaluate.getError() >= survivingPath.getError()) continue;
                    survivorPaths[node.getInputValue()] = pathToEvaluate;
                    continue;
                }
                survivorPaths[node.getInputValue()] = pathToEvaluate;
            }
        }
        return survivorPaths;
    }

    public Path flush(Path[] survivingPaths, int transmittedOutputValue) {
        Node flushingNode = this.createFlushingNode(transmittedOutputValue);
        Path bestPath = null;
        for (Path survivingPath : survivingPaths) {
            if (survivingPath == null) continue;
            survivingPath.add(flushingNode);
            if (bestPath != null && survivingPath.getError() >= bestPath.getError()) continue;
            bestPath = survivingPath;
        }
        return bestPath;
    }
}

