/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import com.google.common.base.Joiner;
import io.github.dsheirer.edac.trellis.Node;
import java.util.ArrayList;
import java.util.List;

public class Path {
    private List<Node> mNodes = new ArrayList<Node>();
    private int mError = 0;

    public Path(Node startingNode) {
        this.add(startingNode);
    }

    private Path(Path original) {
        for (Node node : original.getNodes()) {
            this.add(node);
        }
    }

    public int getError() {
        return this.mError;
    }

    public int getLength() {
        return this.mNodes.size() - 1;
    }

    public List<Node> getNodes() {
        return this.mNodes;
    }

    public void add(Node node) {
        if (!this.mNodes.isEmpty()) {
            this.mError += node.getError(this.getLastNode());
        }
        this.mNodes.add(node);
    }

    public Node getLastNode() {
        if (!this.mNodes.isEmpty()) {
            return this.mNodes.get(this.mNodes.size() - 1);
        }
        return null;
    }

    public Path copyOf() {
        return new Path(this);
    }

    public String toString() {
        return "ERR:" + this.getError() + " " + Joiner.on((String)",").join(this.mNodes);
    }
}

