/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.ReedSolomon_255_DMR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReedSolomon_12_9_4_DMR
extends ReedSolomon_255_DMR {
    private static final Logger mLog = LoggerFactory.getLogger(ReedSolomon_12_9_4_DMR.class);
    private static final int[] FLC_CODEWORD_0 = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] FLC_CODEWORD_1 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] FLC_CODEWORD_2 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] FLC_CODEWORD_3 = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] FLC_CODEWORD_4 = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] FLC_CODEWORD_5 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FLC_CODEWORD_6 = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FLC_CODEWORD_7 = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] FLC_CODEWORD_8 = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] FLC_PARITY_0 = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] FLC_PARITY_1 = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] FLC_PARITY_2 = new int[]{88, 89, 90, 91, 92, 93, 94, 95};

    public ReedSolomon_12_9_4_DMR() {
        super(255, 252);
    }

    public boolean correctFullLinkControl(CorrectedBinaryMessage message, int crcMask) {
        int[] input = new int[255];
        int[] output = new int[255];
        input[0] = message.getInt(FLC_PARITY_2) ^ crcMask;
        input[1] = message.getInt(FLC_PARITY_1) ^ crcMask;
        input[2] = message.getInt(FLC_PARITY_0) ^ crcMask;
        input[3] = message.getInt(FLC_CODEWORD_8);
        input[4] = message.getInt(FLC_CODEWORD_7);
        input[5] = message.getInt(FLC_CODEWORD_6);
        input[6] = message.getInt(FLC_CODEWORD_5);
        input[7] = message.getInt(FLC_CODEWORD_4);
        input[8] = message.getInt(FLC_CODEWORD_3);
        input[9] = message.getInt(FLC_CODEWORD_2);
        input[10] = message.getInt(FLC_CODEWORD_1);
        input[11] = message.getInt(FLC_CODEWORD_0);
        try {
            boolean irrecoverableErrors = this.decode(input, output);
            if (irrecoverableErrors) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        int pointer = 0;
        for (int x = 11; x >= 0; --x) {
            if (output[x] != -1 && output[x] != input[x]) {
                message.load(pointer, 8, output[x]);
                message.setCorrectedBitCount(1);
                return true;
            }
            pointer += 8;
        }
        return true;
    }

    public static void main(String[] args) {
        int[] output = new int[255];
        int[] input = new int[255];
        input[0] = 247;
        input[1] = 236;
        input[2] = 171;
        input[3] = 24;
        input[4] = 46;
        input[5] = 177;
        input[6] = 246;
        input[7] = 205;
        input[8] = 232;
        input[9] = 32;
        input[10] = 124;
        input[11] = 0;
        ReedSolomon_12_9_4_DMR rs = new ReedSolomon_12_9_4_DMR();
        boolean irrecoverable = rs.decode(input, output);
        mLog.info("Irrecoverable: " + irrecoverable);
    }
}

