/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;

public class Hamming13 {
    private static int[] CHECKSUMS = new int[]{15, 14, 7, 10, 5, 11, 12, 6, 3};
    private static int[] ERROR_INDEX = new int[]{-1, 12, 11, 8, 10, 4, 7, 2, 9, -1, 3, 5, 6, -1, 1, 0, -1};

    public static int getErrorIndex(BinaryMessage message, int offset) {
        int syndrome = Hamming13.getSyndrome(message, offset);
        if (syndrome > 0) {
            return offset + ERROR_INDEX[syndrome];
        }
        return -1;
    }

    public static int getErrorIndex(BinaryMessage message, int[] indices) {
        int syndrome = Hamming13.getSyndrome(message, indices);
        if (syndrome > 0) {
            int errorIndex = ERROR_INDEX[syndrome];
            if (errorIndex >= 0 && errorIndex < indices.length) {
                return indices[errorIndex];
            }
            return 10000 + errorIndex;
        }
        return -1;
    }

    private static int calculateChecksum(BinaryMessage message, int offset) {
        int calculated = 0;
        int i = message.nextSetBit(offset);
        while (i >= offset && i < offset + 9) {
            calculated ^= CHECKSUMS[i - offset];
            i = message.nextSetBit(i + 1);
        }
        return calculated;
    }

    private static int calculateChecksum(BinaryMessage message, int[] indices) {
        int calculated = 0;
        for (int x = 0; x < 9; ++x) {
            if (!message.get(indices[x])) continue;
            calculated ^= CHECKSUMS[x];
        }
        return calculated;
    }

    private static int getSyndrome(BinaryMessage message, int[] indices) {
        int calculated = Hamming13.calculateChecksum(message, indices);
        int checksum = 0;
        for (int x = 9; x < 13; ++x) {
            checksum = Integer.rotateLeft(checksum, 1);
            if (!message.get(indices[x])) continue;
            ++checksum;
        }
        return calculated ^ checksum;
    }

    private static int getSyndrome(BinaryMessage message, int offset) {
        int calculated = Hamming13.calculateChecksum(message, offset);
        int checksum = message.getInt(offset + 9, offset + 12);
        return checksum ^ calculated;
    }
}

