/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hamming10 {
    private static final Logger mLog = LoggerFactory.getLogger(Hamming10.class);
    private static int[] CHECKSUMS = new int[]{14, 13, 11, 7, 3, 12};

    public static int checkAndCorrect(CorrectedBinaryMessage frame, int startIndex) {
        int syndrome = Hamming10.getSyndrome(frame, startIndex);
        switch (syndrome) {
            case 0: {
                return 0;
            }
            case 1: {
                frame.flip(startIndex + 9);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 2: {
                frame.flip(startIndex + 8);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 3: {
                frame.flip(startIndex + 4);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 4: {
                frame.flip(startIndex + 7);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                frame.flip(startIndex + 3);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 8: {
                frame.flip(startIndex + 6);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 2;
            }
            case 11: {
                frame.flip(startIndex + 2);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 12: {
                frame.flip(startIndex + 5);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 13: {
                frame.flip(startIndex + 1);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 14: {
                frame.flip(startIndex + 0);
                frame.incrementCorrectedBitCount(1);
                return 1;
            }
            case 15: {
                return 2;
            }
        }
        return 2;
    }

    private static int calculateChecksum(BinaryMessage frame, int startIndex) {
        int calculated = 0;
        int i = frame.nextSetBit(startIndex);
        while (i >= startIndex && i < startIndex + 6) {
            calculated ^= CHECKSUMS[i - startIndex];
            i = frame.nextSetBit(i + 1);
        }
        return calculated;
    }

    private static int getSyndrome(BinaryMessage frame, int startIndex) {
        int calculated = Hamming10.calculateChecksum(frame, startIndex);
        int checksum = frame.getInt(startIndex + 6, startIndex + 9);
        return checksum ^ calculated;
    }
}

