/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;

public class Golay23 {
    public static final int MAX_CORRECTABLE_ERRORS = 3;
    public static final int[] CHECKSUMS = new int[]{1594, 797, 1972, 986, 493, 1740, 870, 435, 1763, 1355, 1183, 1141, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    public static int checkAndCorrect(BinaryMessage frame, int startIndex) {
        int syndrome = Golay23.getSyndrome(frame, startIndex);
        if (syndrome == 0) {
            return 0;
        }
        BinaryMessage copy = frame.getSubMessage(startIndex, startIndex + 23);
        int index = -1;
        int syndromeWeight = 3;
        int errors = 0;
        while (index < 23) {
            if (index != -1) {
                if (index > 0) {
                    copy.flip(index - 1);
                }
                copy.flip(index);
                syndromeWeight = 2;
            }
            if ((syndrome = Golay23.getSyndrome(copy, 0)) <= 0) continue;
            for (int i = 0; i < 23; ++i) {
                errors = Integer.bitCount(syndrome);
                if (errors <= syndromeWeight) {
                    copy.xor(12, 11, syndrome);
                    copy.rotateRight(i, 0, 22);
                    if (index >= 0) {
                        ++errors;
                    }
                    int corrected = copy.getInt(0, 22);
                    int original = frame.getInt(startIndex, startIndex + 22);
                    int errorCount = Integer.bitCount(original ^ corrected);
                    if (errorCount <= 3) {
                        frame.load(startIndex, 23, corrected);
                    }
                    return errorCount;
                }
                copy.rotateLeft(0, 22);
                syndrome = Golay23.getSyndrome(copy, 0);
            }
            ++index;
        }
        return 4;
    }

    private static int getSyndrome(BinaryMessage frame, int startIndex) {
        int calculated = Golay23.calculateChecksum(frame, startIndex);
        int checksum = frame.getInt(startIndex + 12, startIndex + 22);
        return checksum ^ calculated;
    }

    private static int calculateChecksum(BinaryMessage frame, int startIndex) {
        int calculated = 0;
        int i = frame.nextSetBit(startIndex);
        while (i >= startIndex && i < startIndex + 12) {
            calculated ^= CHECKSUMS[i - startIndex];
            i = frame.nextSetBit(i + 1);
        }
        return calculated;
    }
}

