/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import java.util.BitSet;

public class CRCPassport {
    private static final byte sFILL_00 = 0;
    private static byte[] sCHECKSUMS = new byte[]{110, -65, -42, -29, -8, 124, 62, -105, -62, -23, 117, 59, -108, 74, -83, 87, -94, -39, 109, 55, -110, -63, 97, 49, 25, 13, 7, -118, -51, 103, -70, -43, 107, -68, 94, -89, -38, -27, 115, -80, 88, 44, 22, -125, -56, 100, 50, -111, 73, 37, 19};

    public static CRC check(BitSet msg) {
        CRC crc = CRC.UNKNOWN;
        byte calculated = 0;
        int i = msg.nextSetBit(9);
        while (i >= 9 && i <= 59) {
            calculated = (byte)(calculated ^ sCHECKSUMS[i - 9]);
            i = msg.nextSetBit(i + 1);
        }
        calculated = (byte)(calculated ^ CRCPassport.getChecksum(msg));
        switch (calculated) {
            case 0: {
                crc = CRC.PASSED;
                break;
            }
            default: {
                crc = CRC.FAILED_CRC;
            }
        }
        return crc;
    }

    public static byte getResidual(BitSet msg) {
        byte calculated = 0;
        int i = msg.nextSetBit(9);
        while (i >= 9 && i <= 59) {
            calculated = (byte)(calculated ^ sCHECKSUMS[i - 9]);
            i = msg.nextSetBit(i + 1);
        }
        calculated = (byte)(calculated ^ CRCPassport.getChecksum(msg));
        return calculated;
    }

    public static byte[] getChecks() {
        return sCHECKSUMS;
    }

    public static byte getChecksum(BitSet msg) {
        byte retVal = 0;
        for (int x = 0; x < 8; ++x) {
            if (!msg.get(x + 60)) continue;
            retVal = (byte)(retVal ^ (byte)(1 << 7 - x));
        }
        return retVal;
    }

    public static CorrectedBinaryMessage correct(CorrectedBinaryMessage msg) {
        int residual = 0xFF & CRCPassport.getResidual(msg);
        switch (residual) {
            case 1: 
            case 136: {
                msg.flip(67);
                msg.incrementCorrectedBitCount(1);
                break;
            }
            case 3: 
            case 138: {
                msg.flip(66);
                msg.flip(67);
                msg.incrementCorrectedBitCount(2);
                break;
            }
            case 2: 
            case 139: {
                msg.flip(66);
                msg.incrementCorrectedBitCount(1);
                break;
            }
            case 140: {
                msg.flip(65);
                msg.flip(67);
                msg.incrementCorrectedBitCount(2);
                break;
            }
            case 153: {
                msg.flip(67);
                msg.incrementCorrectedBitCount(1);
                break;
            }
            case 142: {
                msg.flip(65);
                msg.flip(66);
                msg.flip(67);
                msg.incrementCorrectedBitCount(3);
            }
        }
        return msg;
    }

    public static boolean isEvenParity(BinaryMessage bits) {
        return bits.cardinality() % 2 == 0;
    }
}

