/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.CRC;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCLJ {
    private static final Logger mLog = LoggerFactory.getLogger(CRCLJ.class);
    private static final int MESSAGE_START = 32;
    private static final int CRC_START = 64;
    private static int[] CHECKSUMS = new int[]{9962, 4981, 48651, 59572, 29786, 14893, 43687, 58082, 29041, 36617, 61493, 53163, 53348, 26674, 13337, 44477, 57711, 50950, 25475, 34416, 17208, 8604, 4302, 2151, 45954, 22977, 39761, 64025, 51901, 53999, 57030, 28515, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    public static CRC checkAndCorrect(BinaryMessage message) {
        int calculated = 0;
        int i = message.nextSetBit(32);
        while (i >= 32 && i < 64) {
            calculated ^= CHECKSUMS[i - 32];
            i = message.nextSetBit(i + 1);
        }
        int checksum = CRCLJ.getChecksum(message);
        if (calculated == checksum) {
            return CRC.PASSED;
        }
        int[] errors = CRCLJ.findBitErrors(calculated ^ checksum);
        if (errors != null) {
            for (int error : errors) {
                message.flip(32 + error);
            }
            return CRC.CORRECTED;
        }
        return CRC.FAILED_CRC;
    }

    public static int getChecksum(BitSet msg) {
        int retVal = 0;
        for (int x = 0; x < 16; ++x) {
            if (!msg.get(x + 64)) continue;
            retVal += 1 << 15 - x;
        }
        return retVal;
    }

    public static int[] findBitErrors(int checksumError) {
        for (int x = 0; x < 48; ++x) {
            if (CHECKSUMS[x] != checksumError) continue;
            int[] errors = new int[]{x};
            return errors;
        }
        return null;
    }

    public static void main(String[] args) {
        BinaryMessage msg = BinaryMessage.load("01010101101010101010000100011000000000100001000110000000001000010001100000000010");
        CRC crc = CRCLJ.checkAndCorrect(msg);
        mLog.debug("CRC:" + crc.getDisplayText());
    }
}

