/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.edac.CRC;
import java.util.BitSet;

public class CRCFleetsync {
    private static short[] sCHECKSUMS = new short[]{29706, 14853, 26888, 13444, 6722, 3361, 29338, 14669, 26796, 13398, 6699, 31007, 18565, 20552, 10276, 5138, 2569, 28942, 14471, 26697, 16430, 8215, 25601, 17930, 8965, 25992, 12996, 6498, 3249, 29266, 14633, 26782, 13391, 28205, 17180, 8590, 4295, 31849, 19006, 9503, 26245, 18248, 9124, 4562, 2281, 28798, 14399, 26645, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    public static CRC check(BitSet msg) {
        CRC crc = CRC.UNKNOWN;
        int calculated = 1;
        if (msg.cardinality() % 2 == 0) {
            int i = msg.nextSetBit(0);
            while (i >= 0 && i < 48) {
                calculated ^= sCHECKSUMS[i];
                i = msg.nextSetBit(i + 1);
            }
            crc = calculated == CRCFleetsync.getChecksum(msg) ? CRC.PASSED : CRC.FAILED_CRC;
        } else {
            crc = CRC.FAILED_PARITY;
        }
        return crc;
    }

    public static int getChecksum(BitSet msg) {
        int retVal = 0;
        for (int x = 0; x < 15; ++x) {
            if (!msg.get(x + 48)) continue;
            retVal += 1 << 14 - x;
        }
        return retVal;
    }

    public static int[] findBitErrors(BitSet msg) {
        int[] retVal = null;
        int checksum = CRCFleetsync.getChecksum(msg);
        checksum ^= 1;
        int i = msg.nextSetBit(0);
        while (i >= 0 && i < 48) {
            checksum ^= sCHECKSUMS[i];
            i = msg.nextSetBit(i + 1);
        }
        if (checksum == 0) {
            retVal = new int[]{63};
        } else {
            for (int x = 0; x < 63; ++x) {
                if (checksum != sCHECKSUMS[x]) continue;
                retVal = new int[]{x};
            }
        }
        return retVal;
    }
}

