/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

public enum CRC {
    PASSED("*", "PASS", true),
    PASSED_INV("#", "PASS INVERTED", true),
    FAILED_CRC("f", "FAIL CRC", false),
    FAILED_PARITY("p", "FAIL PARITY", false),
    CORRECTED("C", "CORRECTED", true),
    UNKNOWN("-", "UNKNOWN", false);

    private String mAbbreviation;
    private String mDisplayText;
    private boolean mPass;

    private CRC(String abbreviation, String displayText, boolean pass) {
        this.mAbbreviation = abbreviation;
        this.mDisplayText = displayText;
        this.mPass = pass;
    }

    public String getAbbreviation() {
        return this.mAbbreviation;
    }

    public String getDisplayText() {
        return this.mDisplayText;
    }

    public boolean passes() {
        return this.mPass;
    }

    public static String format(CRC[] checks) {
        if (checks == null) {
            return UNKNOWN.getAbbreviation();
        }
        StringBuilder sb = new StringBuilder();
        for (CRC check : checks) {
            if (check != null) {
                sb.append(check.getAbbreviation());
                continue;
            }
            sb.append(UNKNOWN.getAbbreviation());
        }
        return sb.toString();
    }
}

