/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.symbol;

import io.github.dsheirer.dsp.symbol.Dibit;

public enum QPSKCarrierLock {
    NORMAL{

        @Override
        public Dibit correct(Dibit dibit) {
            return dibit;
        }
    }
    ,
    PLUS_90{

        @Override
        public Dibit correct(Dibit dibit) {
            switch (dibit) {
                case D00_PLUS_1: {
                    return Dibit.D10_MINUS_1;
                }
                case D01_PLUS_3: {
                    return Dibit.D00_PLUS_1;
                }
                case D10_MINUS_1: {
                    return Dibit.D11_MINUS_3;
                }
            }
            return Dibit.D01_PLUS_3;
        }
    }
    ,
    MINUS_90{

        @Override
        public Dibit correct(Dibit dibit) {
            switch (dibit) {
                case D00_PLUS_1: {
                    return Dibit.D01_PLUS_3;
                }
                case D01_PLUS_3: {
                    return Dibit.D11_MINUS_3;
                }
                case D10_MINUS_1: {
                    return Dibit.D00_PLUS_1;
                }
            }
            return Dibit.D10_MINUS_1;
        }
    }
    ,
    INVERTED{

        @Override
        public Dibit correct(Dibit dibit) {
            switch (dibit) {
                case D00_PLUS_1: {
                    return Dibit.D11_MINUS_3;
                }
                case D01_PLUS_3: {
                    return Dibit.D10_MINUS_1;
                }
                case D10_MINUS_1: {
                    return Dibit.D01_PLUS_3;
                }
            }
            return Dibit.D00_PLUS_1;
        }
    };


    public abstract Dibit correct(Dibit var1);
}

