/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.symbol;

import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DibitToByteBufferAssembler
implements Listener<Dibit>,
IByteBufferProvider {
    private static final Logger mLog = LoggerFactory.getLogger(DibitToByteBufferAssembler.class);
    private ByteBuffer mCurrentBuffer;
    private int mBufferSize;
    private byte mCurrentByte;
    private int mDibitCount;
    private Listener<ByteBuffer> mBufferListener;

    public DibitToByteBufferAssembler(int bufferSize) {
        this.mBufferSize = bufferSize;
        this.getNextBuffer();
    }

    private void getNextBuffer() {
        if (this.mCurrentBuffer != null && this.mBufferListener != null) {
            this.mCurrentBuffer.flip();
            this.mBufferListener.receive(this.mCurrentBuffer);
        }
        this.mCurrentBuffer = ByteBuffer.allocate(this.mBufferSize);
    }

    @Override
    public void receive(Dibit dibit) {
        this.mCurrentByte = (byte)(this.mCurrentByte << 2);
        switch (dibit) {
            case D01_PLUS_3: {
                this.mCurrentByte = (byte)(this.mCurrentByte | 1);
                break;
            }
            case D00_PLUS_1: {
                break;
            }
            case D10_MINUS_1: {
                this.mCurrentByte = (byte)(this.mCurrentByte | 2);
                break;
            }
            case D11_MINUS_3: {
                this.mCurrentByte = (byte)(this.mCurrentByte | 3);
            }
        }
        ++this.mDibitCount;
        if (this.mDibitCount >= 4) {
            this.mCurrentBuffer.put(this.mCurrentByte);
            this.mCurrentByte = 0;
            this.mDibitCount = 0;
            if (!this.mCurrentBuffer.hasRemaining()) {
                this.getNextBuffer();
            }
        }
    }

    @Override
    public void setBufferListener(Listener<ByteBuffer> listener) {
        this.mBufferListener = listener;
    }

    @Override
    public void removeBufferListener(Listener<ByteBuffer> listener) {
        this.mBufferListener = null;
    }

    @Override
    public boolean hasBufferListeners() {
        return this.mBufferListener != null;
    }
}

