/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.symbol;

import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.dsp.symbol.Dibit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DibitDelayBuffer {
    private static final Logger mLog = LoggerFactory.getLogger(DibitDelayBuffer.class);
    protected Dibit[] mBuffer;
    protected int mPointer;

    public DibitDelayBuffer(int length) {
        Validate.isTrue((length > 0 ? 1 : 0) != 0, (String)"Dibit buffer length must be greater than 0", (Object[])new Object[0]);
        this.mBuffer = new Dibit[length];
        this.reset();
    }

    public void reset() {
        for (int x = 0; x < this.mBuffer.length; ++x) {
            this.mBuffer[x] = Dibit.D00_PLUS_1;
        }
    }

    public int length() {
        return this.mBuffer.length;
    }

    public Dibit get(int index) {
        if (index < 0 || index >= this.mBuffer.length) {
            throw new IllegalArgumentException("Index argument must be between 0 and buffer length [" + this.mBuffer.length + "]");
        }
        return this.mBuffer[index];
    }

    public void set(int index, Dibit dibit) {
        if (index < 0 || index >= this.mBuffer.length) {
            throw new IllegalArgumentException("Index argument must be between 0 and buffer length [" + this.mBuffer.length + "]");
        }
        this.mBuffer[index] = dibit;
    }

    public Dibit[] getBuffer() {
        Dibit[] transferBuffer = new Dibit[this.mBuffer.length];
        int transferBufferPointer = 0;
        int bufferPointer = this.mPointer;
        while (transferBufferPointer < transferBuffer.length) {
            transferBuffer[transferBufferPointer++] = this.mBuffer[bufferPointer++];
            if (bufferPointer < this.mBuffer.length) continue;
            bufferPointer = 0;
        }
        return transferBuffer;
    }

    public Dibit[] getBuffer(int start, int length) {
        Dibit[] transferBuffer = new Dibit[length];
        int transferBufferPointer = 0;
        int bufferPointer = (this.mPointer + start) % this.mBuffer.length;
        while (transferBufferPointer < transferBuffer.length) {
            transferBuffer[transferBufferPointer++] = this.mBuffer[bufferPointer++];
            if (bufferPointer < this.mBuffer.length) continue;
            bufferPointer = 0;
        }
        return transferBuffer;
    }

    public CorrectedBinaryMessage getMessage(int start, int dibitLength) {
        CorrectedBinaryMessage message = new CorrectedBinaryMessage(dibitLength * 2);
        int bufferPointer = (this.mPointer + start) % this.mBuffer.length;
        try {
            for (int dibitCount = 0; dibitCount < dibitLength; ++dibitCount) {
                Dibit dibit = this.mBuffer[bufferPointer++];
                message.add(dibit.getBit1());
                message.add(dibit.getBit2());
                if (bufferPointer < this.mBuffer.length) continue;
                bufferPointer = 0;
            }
        }
        catch (BitSetFullException e) {
            mLog.error("Bit set full ??", (Throwable)e);
        }
        return message;
    }

    public int[] getBufferAsArray() {
        Dibit[] dibits = this.getBuffer();
        int[] bits = new int[dibits.length * 2];
        for (int x = 0; x < dibits.length; ++x) {
            if (dibits[x].getBit1()) {
                bits[x * 2] = 1;
            }
            if (!dibits[x].getBit2()) continue;
            bits[x * 2 + 1] = 1;
        }
        return bits;
    }

    public void put(Dibit dibit) {
        this.mBuffer[this.mPointer++] = dibit;
        if (this.mPointer >= this.mBuffer.length) {
            this.mPointer = 0;
        }
    }

    public Dibit getAndPut(Dibit dibit) {
        Dibit toReturn = this.mBuffer[this.mPointer];
        this.put(dibit);
        return toReturn;
    }

    public void log() {
        StringBuilder sb = new StringBuilder();
        int pointer = this.mPointer;
        for (int counter = 0; counter < this.mBuffer.length; ++counter) {
            sb.append(this.mBuffer[pointer].getBit1() ? "1" : "0");
            sb.append(this.mBuffer[pointer++].getBit2() ? "1" : "0");
            if (pointer < this.mBuffer.length) continue;
            pointer = 0;
        }
        mLog.debug("BUFFER: " + String.valueOf(sb) + " Length:" + this.mBuffer.length);
    }
}

