/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.squelch;

import io.github.dsheirer.dsp.filter.iir.SinglePoleIirFilter;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import java.time.Duration;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveSquelch
implements Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(AdaptiveSquelch.class);
    private static final long AUTO_ADJUST_PERIOD_MS = Duration.ofSeconds(5L).toMillis();
    private SinglePoleIirFilter mFilter;
    private float mPower = 0.0f;
    private boolean mSquelch;
    private float mSquelchThreshold;
    private Float mNoiseFloor;
    private float mSquelchBuffer;
    private boolean mSquelchChanged = false;
    private int mPowerLevelBroadcastCount = 0;
    private int mPowerLevelBroadcastThreshold;
    private boolean mAutoTrackNoiseFloor;
    private long mLastAutoAdjustTimestamp;
    private Listener<SourceEvent> mSourceEventListener;

    public AdaptiveSquelch(float alpha, float squelchThreshold, boolean autoTrack) {
        this.mFilter = new SinglePoleIirFilter(alpha);
        this.setSquelchThreshold(squelchThreshold);
        this.mAutoTrackNoiseFloor = autoTrack;
        this.mLastAutoAdjustTimestamp = System.currentTimeMillis();
        this.mPowerLevelBroadcastThreshold = 25000;
    }

    public void setSampleRate(int sampleRate) {
        this.mPowerLevelBroadcastThreshold = sampleRate / 2;
    }

    public float getSquelchThreshold() {
        return this.toDb(this.mSquelchThreshold);
    }

    private float toDb(float value) {
        return 10.0f * (float)FastMath.log10((double)value);
    }

    private float fromDb(float valueDb) {
        return (float)FastMath.pow((double)10.0, (double)((double)valueDb / 10.0));
    }

    public void setSquelchAutoTrack(boolean autoTrack) {
        this.mAutoTrackNoiseFloor = autoTrack;
        this.broadcast(SourceEvent.squelchAutoTrack(this.getSquelchAutoTrack()));
    }

    public boolean getSquelchAutoTrack() {
        return this.mAutoTrackNoiseFloor;
    }

    public void setSquelchThreshold(float squelchThreshold) {
        float squelchThresholdDb = this.fromDb(squelchThreshold);
        this.setSquelchThreshold(squelchThresholdDb, true);
    }

    private synchronized void setSquelchThreshold(float squelchThreshold, boolean resetNoiseFloor) {
        this.mSquelchThreshold = squelchThreshold;
        if (resetNoiseFloor) {
            this.mNoiseFloor = null;
        }
        this.broadcast(SourceEvent.squelchThreshold(null, this.getSquelchThreshold()));
    }

    private void setSquelch(boolean squelch) {
        this.mSquelch = squelch;
        this.mSquelchChanged = true;
    }

    public void process(float inphase, float quadrature) {
        this.process(inphase * inphase + quadrature * quadrature);
    }

    public void process(float magnitude) {
        this.mPower = this.mFilter.filter(magnitude);
        if (this.mSquelch && this.mPower >= this.mSquelchThreshold) {
            this.setSquelch(false);
        } else if (!this.mSquelch && this.mPower < this.mSquelchThreshold) {
            this.setSquelch(true);
        }
        ++this.mPowerLevelBroadcastCount;
        if (this.mPowerLevelBroadcastCount % this.mPowerLevelBroadcastThreshold == 0) {
            this.mPowerLevelBroadcastCount = 0;
            this.broadcast(SourceEvent.channelPowerLevel(null, 10.0 * Math.log10(this.mPower)));
            if (this.mSquelch) {
                this.adjustSquelchThreshold();
            }
        }
    }

    private void adjustSquelchThreshold() {
        if (this.mAutoTrackNoiseFloor) {
            if (this.mNoiseFloor == null) {
                this.mSquelchBuffer = this.mSquelchThreshold - this.mPower;
            }
            this.mNoiseFloor = Float.valueOf(this.mPower);
            if (System.currentTimeMillis() - this.mLastAutoAdjustTimestamp > AUTO_ADJUST_PERIOD_MS) {
                this.setSquelchThreshold(this.mNoiseFloor.floatValue() + this.mSquelchBuffer, false);
                this.mLastAutoAdjustTimestamp = System.currentTimeMillis();
            }
        }
    }

    public boolean isMuted() {
        return this.mSquelch;
    }

    public boolean isUnmuted() {
        return !this.mSquelch;
    }

    public float getPower() {
        return (float)(10.0 * Math.log10(this.mPower));
    }

    public boolean isSquelchChanged() {
        return this.mSquelchChanged;
    }

    public void setSquelchChanged(boolean changed) {
        this.mSquelchChanged = changed;
    }

    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventListener = listener;
    }

    private void broadcast(SourceEvent event) {
        if (this.mSourceEventListener != null) {
            this.mSourceEventListener.receive(event);
        }
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case REQUEST_CHANGE_SQUELCH_THRESHOLD: {
                this.setSquelchThreshold(sourceEvent.getValue().floatValue());
                break;
            }
            case REQUEST_CURRENT_SQUELCH_THRESHOLD: {
                this.broadcast(SourceEvent.squelchThreshold(null, this.getSquelchThreshold()));
                break;
            }
            case REQUEST_CHANGE_SQUELCH_AUTO_TRACK: {
                this.setSquelchAutoTrack(sourceEvent.getValue().intValue() == 1);
                break;
            }
            case REQUEST_CURRENT_SQUELCH_AUTO_TRACK: {
                this.broadcast(SourceEvent.squelchAutoTrack(this.getSquelchAutoTrack()));
            }
        }
    }
}

