/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk.pll;

import io.github.dsheirer.dsp.symbol.Dibit;

public class QPSKPhaseInversionCalculator {
    public static void main(String[] args) {
        String[] syncs;
        for (String sync : syncs = new String[]{"575D57F7FF"}) {
            StringBuilder sbNorm = new StringBuilder();
            StringBuilder sbP90 = new StringBuilder();
            StringBuilder sbM90 = new StringBuilder();
            StringBuilder sb180 = new StringBuilder();
            for (char letter : sync.toCharArray()) {
                int value = Character.isAlphabetic(letter) ? letter - 55 : letter - 48;
                sbNorm.append(letter);
                sbP90.append(QPSKPhaseInversionCalculator.rotate(value, Dibit.Rotation.PLUS90));
                sbM90.append(QPSKPhaseInversionCalculator.rotate(value, Dibit.Rotation.MINUS90));
                sb180.append(QPSKPhaseInversionCalculator.rotate(value, Dibit.Rotation.INVERT));
            }
            System.out.println("NORMAL: " + sync);
            System.out.println("   +90: " + String.valueOf(sbP90));
            System.out.println("   -90: " + String.valueOf(sbM90));
            System.out.println("   180: " + String.valueOf(sb180));
        }
    }

    public static String rotate(int value, Dibit.Rotation direction) {
        try {
            Dibit dibitHigh = QPSKPhaseInversionCalculator.getHighDibit(value);
            Dibit dibitLow = QPSKPhaseInversionCalculator.getLowDibit(value);
            return QPSKPhaseInversionCalculator.getHex(dibitHigh.rotate(direction), dibitLow.rotate(direction));
        }
        catch (Exception exception) {
            return "-";
        }
    }

    public static String getHex(Dibit d1, Dibit d2) {
        int value = d1.getHighValue() + d2.getLowValue();
        return Integer.toHexString(value).toUpperCase();
    }

    public static Dibit getHighDibit(int value) {
        return Dibit.fromValue(value >> 2 & 3);
    }

    public static Dibit getLowDibit(int value) {
        return Dibit.fromValue(value & 3);
    }
}

